/*************************************************************************}
{ timerwindow.cpp - dialog with a timer settings                          }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 25 Mar 2012                                              }
{*************************************************************************/

#include "timerwindow.h"
#include "mainwindow.h"

TimerWindow::TimerWindow(QWidget *parent) :
    CommonDialog(parent)
{
    initGui();
}

TimerWindow::~TimerWindow()
{
    deinitGui();
}

int TimerWindow::showTimerDialog(int mins)
{
    Q_UNUSED(mins);
    TimerWindow* win = new TimerWindow(MAINWINDOW);
    int digits[4];
    if(mins<0)
        mins = 0;
    TimerWindow::minsToDigits(mins, &digits[0]);
    win->spinHrsTens->setValue(digits[3]);
    win->spinHrs->setValue(digits[2]);
    win->spinMinsTens->setValue(digits[1]);
    win->spinMins->setValue(digits[0]);
    int result = win->showDialog();
    if(result == 1)
    {
        result =
                win->spinHrsTens->getValue()*600+
                win->spinHrs->getValue()*60+
                win->spinMinsTens->getValue()*10+
                win->spinMins->getValue();
    }
    else
    {
        result = -1;
    }
    delete win;
    return result;
}

void TimerWindow::minsToDigits(int mins, int *digits)
{
    int tot = mins, div;

    div = tot/10;
    digits[0] = tot - div*10;
    tot = div;

    div = tot/6;
    digits[1] = tot - div*6;
    tot = div;

    div = tot/10;
    digits[2] = tot - div*10;
    tot = div;

    div = tot/10;
    digits[3] = tot - div*10;
}

void TimerWindow::initGui()
{
    CommonDialog::initGui();
    setWindowTitle(tr("Sleep timer"));

    int x = 10;

    labelHrs = new QLabel(this);
    labelHrs->setText(tr("hours"));
    labelHrs->setAlignment(Qt::AlignCenter);
    int h = labelHrs->fontMetrics().height();
    labelHrs->resize(10, h);
    labelMins = new QLabel(this);
    labelMins->setText(tr("minutes"));
    labelMins->resize(10, h);
    labelMins->setAlignment(Qt::AlignCenter);

    spinHrsTens = new SpinNumber(this);
    spinHrsTens->move(x, h);
    x = x + spinHrsTens->width() + 10;
    spinHrs = new SpinNumber(this);
    spinHrs->move(x, h);
    x = x + spinHrs->width();

    int w = x;

    labelSep = new QLabel(this);
    labelSep->move(x, h);
    labelSep->setText(":");
    labelSep->setAlignment(Qt::AlignCenter);
    labelSep->resize(25, 150);
    labelSep->setStyleSheet("font-size:100px;");
    x = x + labelSep->width();

    labelMins->move(x, 0);

    spinMinsTens = new SpinNumber(this);
    spinMinsTens->move(x, h);
    x = x + spinMinsTens->width() + 10;
    spinMins = new SpinNumber(this);
    spinMins->move(x, h);

    labelHrs->move(0, 0);
    labelHrs->resize(w, h);
    labelMins->resize(w, h);

    spinMinsTens->setMaxValue(5);

    btnStart = new QPushButton(this);
    btnStart->setText(tr("Start the timer"));
    connect(btnStart, SIGNAL(clicked()), SLOT(onStartClick()));
}

void TimerWindow::deinitGui()
{
    delete spinHrsTens;
    delete spinHrs;
    delete spinMinsTens;
    delete spinMins;
    delete labelSep;
    delete labelHrs;
    delete labelMins;

    CommonDialog::deinitGui();
}

void TimerWindow::reposition(const QSize &sz)
{
    CommonDialog::reposition(sz);

    int w = sz.width();
    if(w > sz.height())
    {
        btnStart->move(spinMins->x()+spinMins->width()+10, labelHrs->height()+10);
        btnStart->resize(w - btnStart->x() - 10, 100);
    }
    else
    {
        btnStart->move(10, labelHrs->height()+spinMins->height()+10);
        btnStart->resize(spinMins->x()+spinMins->width() - 20, 100);
    }
}

void TimerWindow::onStartClick()
{
    done(1);
}
