/*************************************************************************}
{ selectwindow.cpp - dialog with a list of items to choose one            }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#include "selectwindow.h"

SelectWindow::SelectWindow(QWidget *parent) :
    ContainerDialog(parent)
{
    initGui();
    setResult(-1);
}

SelectWindow::~SelectWindow()
{
    deinitGui();
}

int SelectWindow::showSelectDialog(
        QWidget *parent,
        const QStringList &options,
        int selectedOptionIndex,
        const QString &windowTitle,
        bool alwaysReturnResult
)
{
    SelectWindow* win = new SelectWindow(parent);
    win->setWindowTitle(windowTitle);
    int result = win->showSelectDialog(options, selectedOptionIndex);
    delete win;
    if((result < 0) && alwaysReturnResult)
        return selectedOptionIndex;
    else
        return result;
}

int SelectWindow::showSelectDialog(const QStringList &options, int selectedOptionIndex)
{
    int a = 0;
    int y = 0;
    selectedIndex = selectedOptionIndex;

    KineticListItem* item;
    foreach(QString s, options)
    {
        item = new KineticListItem(itemsContainer);
        item->setInt(a);
        item->move(0, y);
        if(a == selectedOptionIndex)
            item->setIcon(MAINWINDOW->getSkin().icoCheck);
        else
            item->setIcon(MAINWINDOW->getSkin().icoNone);
        item->setText(s);
        item->resize(itemsContainer->width(), ITEM_HEIGHT);
        a++;
        y += ITEM_HEIGHT;
    }

    int result = ContainerDialog::showDialog() - 1; // if exec() returns 0, then it means the choise has not been made

    foreach(QObject* child, itemsContainer->children())
        delete child;

    return result;
}

void SelectWindow::reposition(const QSize &sz, int rows)
{
    Q_UNUSED(rows);
    ContainerDialog::reposition(sz);
    if((selectedIndex >= 0) && (selectedIndex < itemsContainer->children().size()))
        itemsContainer->centerWidgetV((QWidget*)(itemsContainer->children().at(selectedIndex)));
}

void SelectWindow::onItemClick(QWidget *item)
{
    // use 1-based index here, because the result of 0 means the choise has not been made
    done(((KineticListItem*)item)->getInt()+1);
}
