/*************************************************************************}
{ aboutwindow.h - information window                                      }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#ifndef ABOUTWINDOW_H
#define ABOUTWINDOW_H

#include "includes.h"
#include "commondialog.h"

class AboutWindow : public CommonDialog
{
    Q_OBJECT

public:
    explicit AboutWindow(QWidget *parent = 0);
    ~AboutWindow();
    static void showAboutDialog();

protected:
    QString loadTextFromFile(const QString& foldername, const QString &filename);
    QString getDisplayText(const QString& filename);
    void updateText();
    void initGui();
    void deinitGui();
    void reposition(const QSize &sz);

    QButtonGroup* buttons;
    QPushButton *btnApp, *btnLicense, *btnSystem, *btnSkin;
    QTextBrowser* txt;
    StringHash hash;

protected slots:
    void buttonClicked(QAbstractButton* button);
};

#endif // ABOUTWINDOW_H
