/*************************************************************************}
{ qkineticwidget.h - QWidget with kinetic scrolling                       }
{                                                                         }
{ (c) Alexey Parfenov, 2011                                               }
{                                                                         }
{ e-mail: AlkatrazStudio@yandex.ru                                        }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 31 Mar 2012                                             }
{*************************************************************************/

#ifndef QKINETICWIDGET_H
#define QKINETICWIDGET_H

#include <QtGui>

#include "../alkatraz.h"

class QKineticWidget : public QWidget
{
    Q_OBJECT
protected:
    QWidget* inner;

    int ix, iy;
    float x, y;
    int mx, my;
    float spdX, spdY;
    float accX, accY;
    float frictionX, frictionY;
    float backFrictionX, backFrictionY;
    float backSpeedX, backSpeedY;
    int thresholdX, thresholdY;
    int offX, offY;
    int minX, minY;
    bool moveByX, moveByY;
    bool isClick;
    bool isDown;
    int timer;
    int timerInterval;
    int innerWidth, innerHeight;
    int stopSteps, stopStepsLeft;
    QString cssNormal, cssActive;
    QWidget* activeWidget;

    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void timerEvent(QTimerEvent *event);
    void resizeEvent(QResizeEvent *event);
    void contextMenuEvent(QContextMenuEvent *event);
    void childEvent(QChildEvent *event);

    QWidget* getChildAt(int xPos, int yPos);
    void updateConstraintsX();
    void updateConstraintsY();

public:
    explicit QKineticWidget(QWidget *parent = 0);
    ~QKineticWidget();

    void deleteAllChildren();
    void repositionChildrenV(int itemsHeight = -1, int rows = 1);
    void centerWidgetV(const QWidget* widget);

    inline const QString& getCssNormal() const {return cssNormal;}
    inline const QString& getCssActive() const {return cssActive;}
    void setCssNormal(const QString& css);
    void setCssActive(const QString& css);

    inline bool isMoveByX() const {return moveByX;}
    inline bool isMoveByY() const {return moveByY;}
    inline void setMoveByX(bool canMove){moveByX = canMove;}
    inline void setMoveByY(bool canMove){moveByY = canMove;}

    inline float getFrictionX() const {return frictionX;}
    inline float getFrictionY() const {return frictionY;}
    inline void setFrictionX(float value){frictionX = value;}
    inline void setFrictionY(float value){frictionY = value;}

    inline int getMinX() const {return minX;}
    inline int getMinY() const {return minY;}

    inline float getBackFrictionX() const {return backFrictionX;}
    inline float getBackFrictionY() const {return backFrictionY;}
    inline void setBackFrictionX(float value){backFrictionX = value;}
    inline void setBackFrictionY(float value){backFrictionY = value;}

    inline float getBackSpeedX() const {return backSpeedX;}
    inline float getBackSpeedY() const {return backSpeedY;}
    inline void setBackSpeedX(float value){backSpeedX = value;}
    inline void setBackSpeedY(float value){backSpeedY = value;}

    inline int getThresholdX() const {return thresholdX;}
    inline int getThresholdY() const {return thresholdY;}
    inline void setThresholdX(int value){thresholdX = value;}
    inline void setThresholdY(int value){thresholdY = value;}

    inline float getX() const {return x;}
    inline float getY() const {return y;}
    void setX(float value);
    void setY(float value);

    inline void setSpeedX(float speed){spdX = speed;}
    inline void setSpeedY(float speed){spdY = speed;}
    inline float getSpeedX() const {return spdX;}
    inline float getSpeedY() const {return spdY;}

    void scrollX(float offset);
    void scrollY(float offset);

    void setTimerInterval(int msecs);
    inline int getTimerInterval() const {return timerInterval;}

    void setInnerWidth(int value);
    void setInnerHeight(int value);
    inline int getInnerWidth() const {return innerWidth;}
    inline int getInnerHeight() const {return innerHeight;}

    inline void setStopSteps(int value){stopSteps = value;}
    inline int setStopSteps() const {return stopSteps;}

    inline QWidget* getActiveWidget() const {return activeWidget;}

signals:
    void onItemClick(QWidget* item);
    void onItemDown(QWidget* item);
    void onItemUp(QWidget* item, bool isClicked);
    void onContextMenu(QWidget* item, QContextMenuEvent *event);
};

#endif // QKINETICWIDGET_H
