/*************************************************************************}
{ optionitem.h - a graphical representation of a single option            }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#ifndef OPTIONITEM_H
#define OPTIONITEM_H

#include "kineticlistitem.h"
#include "includes.h"
#include "mainwindow.h"
#include "selectwindow.h"

typedef enum {
    oit_None,
    oit_Check,
    oit_SelectInt,
    oit_SelectString,
    oit_Int,
    oit_String
} OptionItemType;

class OptionItem : public KineticListItem
{
    Q_OBJECT

public:
    explicit OptionItem(QWidget *parent = 0);
    
    OptionItemType getType(){return type;}
    void setType(OptionItemType theType);
    int getMinvalue(){return minValue;}
    void setMinValue(int newValue){minValue=newValue;}
    int getMaxValue(){return maxValue;}
    void setMaxValue(int newValue){maxValue=newValue;}
    const QStringList& getStringValues(){return stringValues;}
    void setStringValues(const QStringList& newValues){stringValues = newValues;}
    const QString& getLabelText(){return labelText;}
    void setLabelText(const QString& newText);
    const QString& getIniKey(){return iniKey;}
    void setIniKey(const QString& newKey){iniKey = newKey;fullIniKey="options/"+iniKey;}
    const QVariant& getDefaultValue(){return defaultValue;}
    void setDefaultValue(const QVariant& newValue){defaultValue = newValue;}

    virtual void setString(const QString& newValue);
    virtual void setBool(bool newValue);
    virtual void setInt(int newValue);

    void load();
    void save();
    void updateLabel();
    void updateIcon();
    void init(OptionItemType theType);

    static OptionItem* create(
            QWidget *parent,
            OptionItemType type,
            const QString& iniKey,
            const QVariant& defaultValue,
            const QString& labelText,
            const QStringList& stringValues = QStringList(),
            int minValue = 0,
            int maxValue = 100
            );
    static QVariant getIniValue(const QString& iniKey, const QVariant& defaultValue);

protected:
    OptionItemType type;
    int minValue, maxValue;
    QStringList stringValues;
    QString labelText;
    QString iniKey, fullIniKey;
    QVariant defaultValue;

    void setRawLabelText(const QString& newText);

public slots:
    void click();

};

#endif // OPTIONITEM_H
