/*************************************************************************}
{ aboutwindow.cpp - information window                                    }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#include "aboutwindow.h"
#include "mainwindow.h"

AboutWindow::AboutWindow(QWidget *parent) :
    CommonDialog(parent)
{
    QString s;

    hash["app_title"] = APP_TITLE;
    hash["label_version"] = tr("Version");
    hash["app_version"] = APP_VERSION;
    hash["app_status"] = APP_STATUS;
    hash["label_projsite"] = tr("Project site");
    hash["label_developer"] = tr("Developer");
    hash["label_contactemail"] = tr("Contact email");
    hash["label_contactname"] = tr("Contact name");
    hash["label_devsite"] = tr("Developer's site");
    s = tr("This project was inspired by %1.");
    hash["label_inspired_by"] =  s.arg("<a href=\"http://thecodecentral.com/symfonie\">symfonie</a>");
    hash["compressed_support_label"] = tr("Compressed modules support");
    if(PLAYER->getUnzipPath().isEmpty())
        hash["compressed_support"] = tr("NO (install 'unzip' package for this to work)");
    else
        hash["compressed_support"] = tr("YES");
    hash["equalizer_support_label"] = tr("Equalizer support");
    if(PLAYER->getUnzipPath().isEmpty())
    {
        s = tr("NO (install '%1' gstreamer plugin to enable equalizer)");
        s = s.arg(PLAYER->getEqualizer()->getModuleName());
        hash["equalizer_support"] = s;
    }
    else
    {
        hash["equalizer_support"] = tr("YES");
    }
    hash["supported_mimes_label"] = tr("Supported MIME types");
    hash["support_more_mimes_label"] = tr("To make more MIME types available, install appropriate gstreamer plugins");
    hash["supported_mimes"] = PLAYER->getSupportedMime().join("<br>");
    hash["cur_skin_label"] = tr("Current skin");
    hash["skin_name"] = SKIN.currentSkinName;
    hash["skin_readme_label"] = tr("The following is a contents of README file for a current skin");
    s = "skins/";
    s.append(SKIN.currentSkinName);
    s = loadTextFromFile(s, "README");
    s = Qt::escape(s);
    s.replace("\n", "<br>");
    // make links clickable
    s.replace(QRegExp("(\\w+\\:\\/\\/[\\w\\.\\-\\d\\%\\_\\?\\&\\=\\/]+)"), "<a href=\"\\1\">\\1</a>");
    hash["skin_readme"] = s;

    initGui();
}

AboutWindow::~AboutWindow()
{
    deinitGui();
}

void AboutWindow::showAboutDialog()
{
    AboutWindow* win = new AboutWindow(MAINWINDOW);
    win->showDialog();
    delete win;
}

QString AboutWindow::loadTextFromFile(const QString &foldername, const QString &filename)
{
    QFile f;
    QString fullFilename = APP_DIR + foldername + "/" + filename;
    f.setFileName(fullFilename);
    if(!f.open(QIODevice::ReadOnly))
        return "";
    QString text = QString::fromUtf8(f.readAll().constData());
    f.close();
    return text;
}

QString AboutWindow::getDisplayText(const QString &filename)
{
    return hash.replaceInString(loadTextFromFile("html", filename));
}

void AboutWindow::updateText()
{
    QPushButton* btn = (QPushButton*)(buttons->checkedButton());
    if(!btn)
        return;
    txt->setHtml(btn->property("txt").toString());
}

void AboutWindow::initGui()
{
    CommonDialog::initGui();

    setWindowTitle(tr("About"));

    buttons = new QButtonGroup(this);
    connect(buttons, SIGNAL(buttonClicked(QAbstractButton*)), SLOT(buttonClicked(QAbstractButton*)));

    buttons->addButton(btnApp = new QPushButton(this));
    buttons->addButton(btnSystem = new QPushButton(this));
    buttons->addButton(btnLicense = new QPushButton(this));
    buttons->addButton(btnSkin = new QPushButton(this));

    btnApp->setText(tr("App"));
    btnSystem->setText(tr("System"));
    btnSkin->setText(tr("Skin"));
    btnLicense->setText(tr("License"));

    btnApp->setProperty("txt", getDisplayText("app.html"));
    btnSystem->setProperty("txt", getDisplayText("system.html"));
    btnSkin->setProperty("txt", getDisplayText("skin.html"));
    btnLicense->setProperty("txt", getDisplayText("license.html"));

    btnApp->setCheckable(true);
    btnSystem->setCheckable(true);
    btnSkin->setCheckable(true);
    btnLicense->setCheckable(true);

    btnApp->setChecked(true);

    txt = new QTextBrowser(this);
    txt->setStyleSheet("background:white;color:black;");
    txt->setOpenExternalLinks(true);
    txt->setReadOnly(true);
    txt->setWordWrapMode(QTextOption::WordWrap);
    txt->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    updateText();
}

void AboutWindow::deinitGui()
{
    delete btnApp;
    delete btnSystem;
    delete btnSkin;
    delete btnLicense;
    delete buttons;

    delete txt;

    CommonDialog::deinitGui();
}

void AboutWindow::reposition(const QSize &sz)
{
    CommonDialog::reposition(sz);

    int w = sz.width();
    int h = sz.height();
    int ww;
    int x=0, y=0;

    if(w > h)
    {
        ww = w/4-5;
        btnApp->move(x, y); btnApp->resize(ww, CONTROLBUTTON_SIZE); x=x+ww+5;
        btnSystem->move(x, y); btnSystem->resize(ww, CONTROLBUTTON_SIZE); x=x+ww+5;
        btnSkin->move(x, y); btnSkin->resize(ww, CONTROLBUTTON_SIZE); x=x+ww+5;
        btnLicense->move(x, y); btnLicense->resize(ww+5, CONTROLBUTTON_SIZE);
    }
    else
    {
        ww = w/2-5;
        btnApp->move(x, y); btnApp->resize(ww, CONTROLBUTTON_SIZE); x=x+ww+5;
        btnSystem->move(x, y); btnSystem->resize(ww+5, CONTROLBUTTON_SIZE); x=0; y=y+btnSystem->height()+5;
        btnSkin->move(x, y); btnSkin->resize(ww, CONTROLBUTTON_SIZE); x=x+ww+5;
        btnLicense->move(x, y); btnLicense->resize(ww, CONTROLBUTTON_SIZE);
    }

    y=y+btnSystem->height()+5;

    txt->move(0, y);
    txt->resize(w, h-y);
}

void AboutWindow::buttonClicked(QAbstractButton *button)
{
    Q_UNUSED(button);
    updateText();
}
