/*************************************************************************}
{ skin.h - skin loader                                                    }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#ifndef SKIN_H
#define SKIN_H

#include "includes.h"

struct Skin {
    QIcon icoFile, icoFilePause, icoFilePlay, icoFileStop, icoFolder, icoFolderPlay;
    QIcon icoNext, icoPause, icoPlay, icoPrev, icoStop, icoParent;
    QIcon icoCheck, icoUncheck;
    QIcon icoUp, icoDown;
    QIcon icoItemNew, icoItemDelete, icoItemSave, icoItemRename;
    QIcon icoNone;

    QString cssNormal, cssActive;
    QString cssCommon, cssCommonWindows, cssCommonControls;
    QString skinRoot;
    QString currentSkinName;

    Skin();
    bool loadIcon(QIcon* ico, const QString& filename);
    bool load(const QString& skinName = "default");
    void initKineticWidget(QKineticWidget* kinetic) const;
    QStringList getAvailableSkins() const;
};

#endif // SKIN_H
