/*************************************************************************}
{ qiodevicehelper.h - shortcut functions for QIODevice children           }
{                                                                         }
{ (c) Alexey Parfenov, 2011                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 26 Jun 2011                                              }
{*************************************************************************/

#ifndef QIODEVICEHELPER_H
#define QIODEVICEHELPER_H

#include "alkatraz.h"
#include <QIODevice>
#include <QStringList>

class QIODeviceHelper
{
public:
    QByteArray readUntilChar(char stopChar = 0);
    QByteArray readUntilReturn();

    bool writeStringUTF8(const QString& string, char stopChar = 0);
    bool writeStringASCII(const QString& string, char stopChar = 0);
    QString readStringUTF8(char stopChar = 0);
    QString readStringASCII(char stopChar = 0);
    QString readLineUTF8();
    QString readLineASCII();
    bool readLn(QByteArray& data);
    bool readLnASCII(QString& dstString);
    bool readLnUTF8(QString& dstString);
    bool writeLnASCII(const QString& dstString);
    bool writeLnUTF8(const QString& dstString);
    QStringList readLinesASCII();
    QStringList readLinesUTF8();
    bool writeLinesASCII(const QStringList& lines);
    bool writeLinesUTF8(const QStringList& lines);

    bool writeInt(qint8 value);
    bool writeInt(quint8 value);
    bool writeInt(qint16 value);
    bool writeInt(quint16 value);
    bool writeInt(qint32 value);
    bool writeInt(quint32 value);
    bool writeInt(const qint64& value);
    bool writeInt(const quint64& value);

    bool writeInt8(qint8 value){return writeInt(value);}
    bool writeUint8(quint8 value){return writeInt(value);}
    bool writeInt16(qint16 value){return writeInt(value);}
    bool writeUint16(quint16 value){return writeInt(value);}
    bool writeInt32(qint32 value){return writeInt(value);}
    bool writeUint32(quint32 value){return writeInt(value);}
    bool writeInt64(const qint64& value){return writeInt(value);}
    bool writeUint64(const quint64& value){return writeInt(value);}

    qint8 readInt8();
    quint8 readUint8();
    qint16 readInt16();
    quint16 readUint16();
    qint32 readInt32();
    quint32 readUint32();
    qint64 readInt64();
    quint64 readUint64();

    bool writeBool(bool value){return writeUint8(value);}
    bool readBool(){return readUint8();}
};

/*
class QIODeviceEx: public QIODevice, public QIODeviceHelper {};
class QAbstractSocketEx: public QAbstractSocket, public QIODeviceHelper {};
class QBufferEx: public QBuffer, public QIODeviceHelper {};
class QFileEx: public QFile, public QIODeviceHelper {};
class QLocalSocketEx: public QLocalSocket, public QIODeviceHelper {};
class QNetworkReplyEx: public QNetworkReply, public QIODeviceHelper {};
class QProcessEx: public QProcess, public QIODeviceHelper {};
*/

#endif // QIODEVICEHELPER_H
