/*************************************************************************}
{ kineticlistitem.h - an item to be used in a kinetic scroller            }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#ifndef KINETICLISTITEM_H
#define KINETICLISTITEM_H

#include <QtGui>

class KineticListItem : public QCommandLinkButton
{
    Q_OBJECT

protected:
    void mousePressEvent(QMouseEvent *event){event->ignore();}
    void mouseReleaseEvent(QMouseEvent *event){event->ignore();}
    void mouseMoveEvent(QMouseEvent *event){event->ignore();}

    QString stringValue;
    bool boolValue;
    int intValue;

public:
    explicit KineticListItem(QWidget *parent = 0);

    const QString& getString(){return stringValue;}
    virtual void setString(const QString& newValue){stringValue = newValue;}
    bool getBool(){return boolValue;}    
    virtual void setBool(bool newValue){boolValue = newValue;}
    int getInt(){return intValue;}
    virtual void setInt(int newValue){intValue = newValue;}
};

#endif // KINETICLISTITEM_H
