###########################################################################
# rhapsodie.pro - main project file                                       #
#                                                                         #
# This file is a part of the project                                      #
#   Rhapsodie - Music player for N900                                     #
#                                                                         #
# (c) Alkatraz Studio, 2012                                               #
#                                                                         #
# author: Parfenov Alexey a.k.a. ZXED                                     #
# author's e-mail: zxed@alkatrazstudio.net                                #
# official project site: http://rhapsodie.garage.maemo.org/               #
#                                                                         #
# This program is free software; you can redistribute it and/or           #
# modify it under the terms of the GNU General Public License             #
# as published by the Free Software Foundation; either version 3 of       #
# the License, or (at your option) any later version.                     #
#                                                                         #
# This program is distributed in the hope that it will be useful,         #
# but WITHOUT ANY WARRANTY; without even the implied warranty of          #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        #
# General Public License for more details.                                #
#                                                                         #
# You may read GNU General Public License at:                             #
#   http://www.gnu.org/copyleft/gpl.html                                  #
#                                                                         #
# project started: 09 Feb 2012                                            #
# project version: 0.1                                                    #
# project last modified: 21 Mar 2012                                      #
#                                                                         #
# last modified: 21 Mar 2012                                              #
###########################################################################

# Add files and directories to ship with the application
# by adapting the examples below.
# file1.source = myfile
# dir1.source = mydir
TARGET=rhapsodie
QT += phonon dbus

DEPLOYMENTFOLDERS = # file1 dir1

# If your application uses the Qt Mobility libraries, uncomment
# the following lines and add the respective components to the
# MOBILITY variable.
# CONFIG += mobility
# MOBILITY +=

INCLUDEPATH = src

SOURCES += \
    src/main.cpp \
    src/mainwindow.cpp \
    src/../inc/alkatraz.cpp \
    src/phononplayer.cpp \
    src/../inc/qiodevicehelper.cpp \
    src/../inc/fsman.cpp \
    src/../inc/controls/qkineticwidget.cpp \
    src/kineticlistitem.cpp \
    src/app.cpp \
    src/typeswindow.cpp \
    src/optionswindow.cpp \
    src/optionitem.cpp \
    src/selectwindow.cpp \
    src/containerdialog.cpp \
    src/equalizer.cpp \
    src/commondialog.cpp \
    src/../inc/qwidgethelper.cpp \
    src/equalizerwindow.cpp \
    src/button.cpp \
    src/aboutwindow.cpp \
    src/skin.cpp \
    src/../inc/stringhash.cpp \
    src/timerwindow.cpp \
    src/spinnumber.cpp
HEADERS += \
    src/mainwindow.h \
    src/../inc/alkatraz.h \
    src/phononplayer.h \
    src/../inc/qiodevicehelper.h \
    src/../inc/fsman.h \
    src/../inc/controls/qkineticwidget.h \
    src/kineticlistitem.h \
    src/app.h \
    src/includes.h \
    src/typeswindow.h \
    src/skin.h \
    src/optionswindow.h \
    src/optionitem.h \
    src/selectwindow.h \
    src/containerdialog.h \
    src/equalizer.h \
    src/commondialog.h \
    src/../inc/qwidgethelper.h \
    src/equalizerwindow.h \
    src/button.h \
    src/aboutwindow.h \
    src/../inc/stringhash.h \
    src/timerwindow.h \
    src/spinnumber.h
FORMS +=

# Please do not modify the following two lines. Required for deployment.
include(deployment.pri)
qtcAddDeployment()

OTHER_FILES += \
    qtc_packaging/debian/rules \
    qtc_packaging/debian/README \
    qtc_packaging/debian/copyright \
    qtc_packaging/debian/control \
    qtc_packaging/debian/compat \
    qtc_packaging/debian/changelog

RESOURCES +=

TRANSLATIONS = translations/rhapsodie_ru.ts

maemo5 {
    DEFINES += MAEMO5

    DESTDIR = ./bin/

    i_tr.path = /opt/rhapsodie/translations
    i_tr.files = translations/rhapsodie_ru.qm
    INSTALLS += i_tr
    i_skins.path = /opt/rhapsodie
    i_skins.files = skins
    INSTALLS += i_skins
    i_data.path = /opt/rhapsodie
    i_data.files = data
    INSTALLS += i_data
    i_html.path = /opt/rhapsodie
    i_html.files = html
    INSTALLS += i_html
}

VERSION=0.1

DEFINES += \
    APP_VERSION=\\\"$$VERSION\\\" \
    APP_NAME=\\\"$$TARGET\\\" \
    APP_STATUS=\\\"alpha\\\" \
    APP_TITLE=\\\"Rhapsodie\\\"
