#!/usr/bin/env python
# -*- coding: utf-8 -*-

#########################################################################
#    Copyright (C) 2010 Sergio Villar Senin <svillar@igalia.com>
#
#    This file is part of ReSiStance
#
#    ReSiStance is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    ReSiStance is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with ReSiStance.  If not, see <http://www.gnu.org/licenses/>.
#########################################################################

import os
import constants
from portrait import FremantleRotation
from configobj import ConfigObj
from validate import Validator

class Settings(object):

    def __init__(self):
        self.reset_to_defaults()
        self.config = None
        self.validator = Validator()
        self.spec = ConfigObj(constants.RSS_SPEC_FILE, encoding='UTF8',
                              list_values=False)

    def reset_to_defaults(self):
        self.feeds_order = constants.ASCENDING_ORDER
        self.default_font_size = 16
        self.auto_load_images = True
        self.rotation_mode = FremantleRotation.AUTOMATIC

    def load(self):
        if not (os.path.exists(constants.RSS_CONF_FILE) and
                os.path.isfile(constants.RSS_CONF_FILE)):
            return

        if self.config == None:
            self.config = ConfigObj(constants.RSS_CONF_FILE, configspec=self.spec)
            if self.config.validate(self.validator) == False:
                self.reset_to_defaults()
                return

        self.feeds_order = self.config['feeds_order']
        self.default_font_size = self.config['default_font_size']
        self.auto_load_images = self.config['auto_load_images']
        self.rotation_mode = self.config['rotation_mode']

    def save(self):
        if self.config == None:
            self.config = ConfigObj(constants.RSS_CONF_FILE, configspec=self.spec)
            self.config.validate(self.validator)

        self.config['feeds_order'] = self.feeds_order
        self.config['default_font_size'] = self.default_font_size
        self.config['auto_load_images'] = self.auto_load_images
        self.config['rotation_mode'] = self.rotation_mode

        self.config.write()
