#
# Keyboard repeat switcher widget for Maemo 5 PR 1.2
# Copyright (c) 2010-05-14 Thomas Perl <thp@thpinfo.com>
# License: GPLv3 or (at your option) any later version
#

import hildondesktop

import gobject
import gtk
import hildon

import gconf

class RepeatSwitcherWidget(hildondesktop.StatusMenuItem):
    KEY = '/apps/osso/inputmethod/ext_kb_repeat_enabled'

    def __init__(self):
        hildondesktop.StatusMenuItem.__init__(self)
        self._client = gconf.Client()

        hb = gtk.HBox()

        rb1 = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT |
                gtk.HILDON_SIZE_AUTO_WIDTH)
        rb1.set_mode(0)
        rb1.set_property('label', 'Longpress')

        rb2 = hildon.GtkRadioButton(gtk.HILDON_SIZE_FINGER_HEIGHT |
                gtk.HILDON_SIZE_AUTO_WIDTH, rb1)
        rb2.set_mode(0)
        rb2.set_property('label', 'Repeat')

        rb2.set_active(self._client.get_bool(self.KEY))
        rb2.connect('toggled', self.on_toggled)

        hb.add(rb1)
        hb.add(rb2)

        self.add(hb)
        self.show_all()

    def on_toggled(self, widget):
        self._client.set_bool(self.KEY, widget.get_active())

hd_plugin_type = RepeatSwitcherWidget

if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="repeat_switcher")
    obj.show_all()
    gtk.main()

