import Qt 4.7
import QtWebKit 1.0

Rectangle {
        id: webBrowser
        property int show: 1
        property string urlString : ""
        property alias htmlstring: webView.html
        property alias theurl: webView.url
        property alias thereload: webView.reload
        color: "#f2f2f2"
        clip: true
        FlickableWebView {
            id: webView
            url: webBrowser.urlString           
            anchors.fill: parent
        }

        Scrollbar {
            scrollArea: webView; width: 8
            anchors { right: webView.right; top: webView.top; bottom: webView.bottom }
        }

        Scrollbar {
            scrollArea: webView; height: 8; orientation: Qt.Horizontal
            anchors { right: webView.right; rightMargin: 8; left: webView.left; bottom: webView.bottom }
        }

        Rectangle {
            id: progressbar
            x: 0; y: webView.height - 20;


            Text {
                id: per
                text: getper() + "%"
                style: Text.Raised
                styleColor: "blue"
                font.bold: true
                font.pixelSize: 20
                color: "white"
                anchors.right: parent.right
                function getper()
                {
                    var a = Math.round(webView.progress * 100);
                    //var b = a + "%";
                    return a;
                }
            }



            height: 20; width: webView.width * webView.progress
            color: "#63b1ed"
            opacity: (webView.progress == 1.0 || show == 0)? 0.0 : 1.0
        }
}
