import Qt 4.7

Item{
    id: mybutton
    property string text
    property bool keyUsing: false
    property alias presssource: pressed.source
    property alias imagesource: button.source
    property alias textcolor: btntext.color
    property int textsize: 18
    signal clicked

    MouseArea{
        id: mouseregion
        anchors.fill: mybutton
        onClicked:{mybutton.clicked();}
    }

    BorderImage {
        id: button
        source: "button.png"
        opacity: 1
        smooth: true
        width: mybutton.width; height: mybutton.height
    }
    BorderImage {
        id: pressed
        source: "button1pressed.sci"
        opacity: 0
        smooth: true
        width: mybutton.width; height: mybutton.height
    }

    Text{
        id: btntext
        width: parent.width
        anchors.centerIn: button
        elide: Text.ElideRight
        horizontalAlignment: Text.AlignHCenter
        color: "white"//#D0D0D0"
        text: mybutton.text
        styleColor: "black"
        font.bold: true
        font.pixelSize: 18
        font.family: "宋体"
    }
    states: [
        State {
            name: "pressed"
            when: mouseregion.pressed == true
            PropertyChanges {target: button; opacity: 0}
            PropertyChanges {target: pressed; opacity: 1}
        }
    ]
    transitions: Transition {
        ColorAnimation { target: btntext }
        NumberAnimation { property: "opacity"; duration: 100 }
    }
}
