import Qt 4.7
//import "Public"
import "SendPost.js" as SendPost
//import "NewsFeed"
//import "Friend"
//import "Ablum"
//import "Message"
//import com.nokia.meego 1.0

//Page{
//    id: mainview
//    lockInPortrait: true
//     visible: true
//     status: PageStatus.PageStatus.Active
Item{
    id: mainview
    property string ticket: ""
    property string sessionkey: ""
    property string uid: ""
    property string secret_key: ""
    property string username: ""
    property string loginname:""
    property string loginpasswd: ""
    property string head_url: ""
    property int newMsgs : 0

    function clear()
    {
        myfeed.listmodel.clear();
        newsfeed.listmodel.clear();
        friend.listmodel.clear();
        ablum.listmodel.clear();
        message.listmodel.clear();
    }

    function getNewsCount()
    {
        function getNewsCountCallBack(){}

        getNewsCountCallBack.prototype = {
            update: function(a)
            {
                        if(a.error_msg == undefined)
                        {
                            mainview.newMsgs = a.gossip_reply_count;
                        }
                    }
        }

        SendPost.getNewsCount(sessionkey, new getNewsCountCallBack());
    }

//    Timer {
//        id: getnews

//        interval: 1 * 30000 // 1 min.
//        running: true
//        repeat: true

//        onTriggered: {
//            getNewsCount();
//        }
//    }


    function loaddata()
    {
        var i;
        var pics = new Array();
        var picspress = new Array();
        var names = new Array();

        pics[0] = "homepage.png";
        pics[1] = "newsfeed.png";
        pics[2] = "friend.png";
        pics[3] = "album.png";
        pics[4] = "status.png";
        pics[5] = "blog.png";
        pics[6] = "homepage.png";

        names[0] = "个人主页";
        names[1] = "新鲜事";
        names[2] = "好友";
        names[3] = "相册";
        names[4] = "发状态";
        names[5] = "写日志";
        names[6] = "个人资料";

        mainModel.clear();

        for(i = 0; i < 7; i++)
        {
            mainModel.append({
                                 "id" : i,
                                 "pic": pics[i],
                                 "name":names[i]
                             })
        }
    }

    Item{
        id: head
        width: parent.width
        height: 80

        Image {
            id: headbg
            anchors.fill:  parent
            source: "headbg.png"
        }

        Image {
            id: logo
            anchors.verticalCenter: parent.verticalCenter
            anchors.left: parent.left
            anchors.leftMargin: 20
            source: "LoginLogov.png"
        }

        Item{
            id: usernameItem
            width: parent.width - logo.width - login.width - 50
            anchors.centerIn:  parent
            Text {
                id: username1
                width: parent.width
                anchors.centerIn:  parent
                elide: Text.ElideRight
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                font.letterSpacing: -1
                color: "white"
                font.bold: true
                font.pixelSize: 26
                font.family: "宋体"
                text: username
            }
        }

        MyButton { // log in
           id: login
           width: 80
           height: 46
           opacity: 1
           anchors.verticalCenter: parent.verticalCenter
           anchors.right: parent.right
           anchors.rightMargin: 20
           text: "注销"
           keyUsing: true;
           imagesource: "ok.png"
           presssource: "ok_press.png"
           onClicked:
           {
               form.isSwitchUser = true;
               clear();
               form.state = "loginview";
           }
        }
    }

    Item{
        id: bottomItem
        anchors.bottom: parent.bottom
        width: parent.width
        height: 80

        Image {
            id: bottombg
            anchors.fill:  parent
            source: "bottombg.png"
        }

        Column{
            anchors.centerIn: parent
            spacing: 15
            Row{
                Image {
                    id: bubble
                    source: "bubble.png"
                    property alias msgs : mainview.newMsgs
                    opacity: msgs > 0 ? 1 : 0

                    Text {
                        id: text
                        anchors.centerIn: parent
                        text: bubble.msgs
                        font.bold: true
                        smooth: true
                        color: "white"
                        font.family: "Times New Roman"
                    }
                }
                Text {
                    id: messages
                    anchors.verticalCenter: parent.verticalCenter
                    color: "#005EAC"
                    style: Text.Raised
                    font.bold: false
                    font.pixelSize: 26
                    font.family: "宋体"
                    text: "消息"
                }
            }
        }

        MouseArea {
            anchors.fill: parent
            onClicked: {

                function getMessageList() {}

                getMessageList.prototype = {
                    update: function(a)
                            {
                                message.model = a;
                                message.enter();
                                interact.closeBusy();
                                mainview.state = "message";
                            }
                }
                SendPost.getNewMessageList(sessionkey, 1, new getMessageList());
                interact.showBusy("数据加载中，请稍候...");
            }
        }
    }

    ListModel {
        id : mainModel
    }

    GridView {
        id: gridlist
        x: 0
        y: head.height
        width: parent.width
        height: parent.height - head.height - bottomItem.height
        cellHeight: 150
        cellWidth: 150
        model: mainModel
        focus: true
        clip: true
        delegate: MainGridDelegate {
            onClicked:
            {
                if(currentItem == 0 || currentItem == 1 || currentItem == 2 || currentItem == 3 || currentItem == 6)
                {
                    interact.showBusy("数据加载中，请稍候...");
                }
                function requestNewsfeed() {}
                function requestMyNewsfeed() {}
                function getFriends() {}
                function getAblum() {}
                function getFriendInfo() {}
                getAblum.prototype = {
                    update: function(a)
                            {
                                ablum.model = a;
                                ablum.enter();
                                interact.closeBusy();
                                mainview.state = "ablum";
                            }
                }

                getFriends.prototype = {
                    update: function(a)
                            {
                                interact.closeBusy();
                                friend.model = a;
                                friend.enter();
                                mainview.state = "friend";
                            }
                }

                getFriendInfo.prototype = {
                    update: function(a)
                            {
                                interact.closeBusy();
                                userinfo.model = a;
                                userinfo.getfriendinfo();
                                mainview.state = "userinfo";
                            }
                }

                requestNewsfeed.prototype = {
                    update: function(a)
                            {
                                newsfeed.model = a;
                                newsfeed.enter();
                                mainview.state = "newsfeed";
                            }
                }

                requestMyNewsfeed.prototype = {
                    update: function(a)
                            {
                                interact.closeBusy();
                                myfeed.listmodel.clear();
                                myfeed.model = a;
                                myfeed.enter();
                                mainview.state = "myfeed";
                            }
                }

                switch(currentItem)
                {
                case 0:
                    SendPost.getMyNewsfeed(mainview.sessionkey, mainview.uid, 1, new requestMyNewsfeed());
                    break;
                case 1:
                    SendPost.getNewsfeed(mainview.sessionkey, 1, new requestNewsfeed());
                    break;
                case 2:
                    SendPost.getFriends(mainview.sessionkey, 1, new getFriends());
                    break;
                case 3:
                    SendPost.getAblums(mainview.sessionkey, mainview.uid, 1, new getAblum());
                    break;
                case 4:
                    sendstatus.state = "enter";
                    break;
                case 5:
                    writeblog.state = "enter";
                    break;
                case 6:
                    SendPost.getFriendInfo(mainview.sessionkey, mainview.uid, new getFriendInfo());
                    break;
                default:
                    break;
                }
            }
        }
    }

    Reply{
        id: sendstatus
        width: parent.width
        height: parent.height
        anchors.fill: parent
        opacity: 0

        lefttext: "取消"
        midtext:  "发布状态"
        righttext: "发布"
        maxtext: 140
        charStep: 1

        onExit:
        {
            sendstatus.state = "";
        }

        onRightbuttonclicked:
        {
            function Result(){}
            Result.prototype = {
                    update: function(a)
                    {
                                interact.closeBusy();
                                if(a.result == 1)
                                {
                                    console.log("Success");
                                    sendstatus.success("发布成功");
                                    sendstatus.state = "";
                                }
                                else
                                {
                                    if(a.error_msg != undefined)
                                    {
                                        sendstatus.fail(a.error_msg);
                                    }
                                    else
                                    {
                                        sendstatus.fail("发布失败");
                                    }
                                }

                    }
            }
         SendPost.sendStatus(sessionkey, inputtext,new Result());
         interact.showBusy("正在发布")
        }

        states: [
            State{
             name: "enter"
             PropertyChanges { target: sendstatus; opacity:1; }
             PropertyChanges { target: gridlist; opacity: 0; }
             PropertyChanges { target: bottomItem; opacity: 0; }
             }
        ]

        transitions: Transition {
            NumberAnimation { properties: "x,y,opacity"; duration: 600 }
        }
    }

    NewsFeed{
        id: myfeed
        anchors.fill: parent
        sessionkey: mainview.sessionkey
        loginname:  mainview.loginname
        loginpasswd: mainview.loginpasswd
        uid: mainview.uid
        flag: 0
        opacity:  0
    }

    NewsFeed{
        id: newsfeed
        anchors.fill: parent
        sessionkey: mainview.sessionkey
        loginname:  mainview.loginname
        loginpasswd: mainview.loginpasswd
        flag:1
        opacity:  0
    }

    Friend{
        id:friend
        anchors.fill: parent
        sessionkey:mainview.sessionkey
        uid: mainview.uid
        opacity: 0
    }

    Ablum{
        id: ablum
        anchors.fill: parent
        sessionkey:mainview.sessionkey
        uid: mainview.uid
        opacity: 0
    }

    Message{
        id: message
        anchors.fill: parent
        sessionkey:mainview.sessionkey
        uid: mainview.uid
        head_url: mainview.head_url
        opacity: 0
    }
    UserInfo{
        id: userinfo
        anchors.fill: parent
        sessionkey:mainview.sessionkey
        uid: mainview.uid
        head_url: mainview.head_url
        opacity: 0
    }
    WriteBlog{
        id: writeblog
        anchors.fill: parent
        opacity: 0

        onRightbuttonclicked: {
            if(writeblog.title == "")
            {
                interact.show("请输入标题");
                return;
            }

            if(writeblog.content == "")
            {
                interact.show("请输入内容");
                return;
            }

            function requestWriteBlog(){};
            requestWriteBlog.prototype = {
                    update:function(a) {
                               interact.closeBusy();

                               if(a.error_msg != undefined)
                               {
                                   interact.show(a.error_msg);
                               }
                               else
                               {
                                   interact.show("发布成功");
                                   writeblog.state = "";
                                   writeblog.title = "";
                                   writeblog.content = "";
                               }
                           }
            }
            SendPost.requestWriteBlog (writeblog.title, writeblog.content, sessionkey, new requestWriteBlog());
            interact.showBusy("正在发布");
        }

        onExit:{
            writeblog.state = "";
            writeblog.state = "";
            writeblog.title = "";
        }

        states: [
            State{
             name: "enter"
             PropertyChanges { target: writeblog; opacity:1; }
             }
        ]

        transitions: Transition {
            NumberAnimation { properties: "x,y,opacity"; duration: 600 }
        }
    }

    states: [
        State {
            name: "myfeed";
            PropertyChanges { target: head; opacity: 0;}
            PropertyChanges { target: bottomItem; opacity: 0;}
            PropertyChanges { target: gridlist; opacity: 0;}
            PropertyChanges { target: friend; opacity: 0;}
            PropertyChanges { target: ablum; opacity: 0;}
            PropertyChanges { target: newsfeed; opacity: 0;}
            PropertyChanges { target: message; opacity: 0;}
            PropertyChanges { target: userinfo; opacity: 0;}
            PropertyChanges { target: myfeed; opacity: 1;}
        },
        State {
            name: "newsfeed";
            PropertyChanges { target: myfeed; opacity: 0;}
            PropertyChanges { target: head; opacity: 0;}
            PropertyChanges { target: bottomItem; opacity: 0;}
            PropertyChanges { target: gridlist; opacity: 0;}
            PropertyChanges { target: friend; opacity: 0;}
            PropertyChanges { target: ablum; opacity: 0;}
            PropertyChanges { target: message; opacity: 0;}
            PropertyChanges { target: userinfo; opacity: 0;}
            PropertyChanges { target: newsfeed; opacity: 1;}
        },
        State {
            name: "friend";
            PropertyChanges { target: myfeed; opacity: 0;}
            PropertyChanges { target: head; opacity: 0;}
            PropertyChanges { target: bottomItem; opacity: 0;}
            PropertyChanges { target: gridlist; opacity: 0;}
            PropertyChanges { target: newsfeed; opacity: 0;}
            PropertyChanges { target: ablum; opacity: 0;}
            PropertyChanges { target: message; opacity: 0;}
            PropertyChanges { target: userinfo; opacity: 0;}
            PropertyChanges { target: friend; opacity: 1;}
        },
        State {
            name: "ablum";
            PropertyChanges { target: myfeed; opacity: 0;}
            PropertyChanges { target: head; opacity: 0;}
            PropertyChanges { target: bottomItem; opacity: 0;}
            PropertyChanges { target: gridlist; opacity: 0;}
            PropertyChanges { target: newsfeed; opacity: 0;}
            PropertyChanges { target: friend; opacity: 0;}
            PropertyChanges { target: message; opacity: 0;}
            PropertyChanges { target: userinfo; opacity: 0;}
            PropertyChanges { target: ablum; opacity: 1;}

        },
        State {
            name: "message";
            PropertyChanges { target: myfeed; opacity: 0;}
            PropertyChanges { target: head; opacity: 0;}
            PropertyChanges { target: bottomItem; opacity: 0;}
            PropertyChanges { target: gridlist; opacity: 0;}
            PropertyChanges { target: newsfeed; opacity: 0;}
            PropertyChanges { target: friend; opacity: 0;}
            PropertyChanges { target: ablum; opacity: 0;}
            PropertyChanges { target: userinfo; opacity: 0;}
            PropertyChanges { target: message; opacity: 1;}
        },
        State {
            name: "userinfo";
            PropertyChanges { target: myfeed; opacity: 0;}
            PropertyChanges { target: head; opacity: 0;}
            PropertyChanges { target: bottomItem; opacity: 0;}
            PropertyChanges { target: gridlist; opacity: 0;}
            PropertyChanges { target: newsfeed; opacity: 0;}
            PropertyChanges { target: friend; opacity: 0;}
            PropertyChanges { target: ablum; opacity: 0;}
            PropertyChanges { target: message; opacity: 0;}
            PropertyChanges { target: userinfo; opacity: 1;}
        }
    ]

    transitions: [
        Transition {
            NumberAnimation { properties: "x,y,opacity"; duration: 600;}
        }
    ]
}
