import Qt 4.7
//import "../../Public"
import "SendPost.js" as SendPost

Item {
    id: wrapper; width: wrapper.ListView.view.width; height: getHeight();
    signal clicked(int currentItem, int type)
    signal more;
    function getHeight() {
        switch(type) {
        case 502:
            return statusFeed.height+80;
            break;
        case 102:
        case 601:
            return blogFeed.height+80;
            break;
        case 701:
        case 103:
            console.log("url = " + url);
            return albumFeed.height + 90;
            break;
        default:
            console.log(type);
            return 86;
            break;
        }
    }

    Item {
        id: feedItem
        anchors.fill:  parent
        opacity: id != 1? 1 : 0
        BorderImage {
            anchors {
                fill: head
                leftMargin: -6; topMargin: -6; rightMargin: -8; bottomMargin: -8
            }
            source: 'box-shadow.png'; smooth: true
            border.left: 10; border.top: 10; border.right: 10; border.bottom: 10
        }
        Rectangle {
            id: head
            x: 11; y: 15; width: 50; height: 50;
            BusyIndicator { anchors.fill: parent; on: headImage.status != Image.Ready }
            Image {
                id: headImage; source: head_url; x: 0; y: 0
                anchors.fill:  parent; clip: true
            }
        }
        Item {
            id: nameTime
            x: 77; y: 15; width: wrapper.ListView.view.width - 95;
            Text {
                text: user_name; color: "#005EAC"; wrapMode: Text.WrapAnywhere; width: parent.width; font.family: "宋体";
                font.bold: true; font.pixelSize: 21
                smooth: true
            }
            Text { text: SendPost.getFullTime(time); width: parent.width; elide: Text.ElideRight; color: "#808080"; font.pixelSize: 20; horizontalAlignment: Text.AlignRight; font.family: "宋体" }
        }

        Column {
            id: statusFeed; visible:  type == 502
            x: 77; y: 46; width:  wrapper.ListView.view.width - 95;
            Text {
                id: status; text: title + (share_status != undefined?share_status:""); color:"black"; wrapMode: Text.WrapAnywhere; width: parent.width;
                font.bold: false; font.family: "宋体"; font.pixelSize: 21; font.letterSpacing: 1.8;
                smooth: true
            }
        }
        Column {
            id: blogFeed; visible:  type == 601 || type == 102
            x: 77; y: 46; width: wrapper.ListView.view.width - 95;
            spacing: 5
            Text {
                text: prefix + ":" +title;
                color: "black"; wrapMode: Text.WrapAnywhere; width: parent.width;
                font.bold: false; font.family: "宋体"; font.pixelSize: 21; font.letterSpacing: 1.8;
                smooth: true
            }
            Text {
                text: description != undefined?description : "";
                color: "black"; wrapMode: Text.WrapAnywhere; width: parent.width;
                font.bold: false; font.family: "宋体"; font.pixelSize: 21; font.letterSpacing: 1.8;
                smooth: true
            }
        }

        Column {
            id: albumFeed; visible:  type == 701 || type == 103
            x: 77; y: 46; width: wrapper.ListView.view.width - 95;
            spacing: 15
            Text {
                text: prefix + ": " + title
                color: "black"; wrapMode: Text.WrapAnywhere; width: parent.width;
                font.bold: false; font.family: "宋体"; font.pixelSize: 21; font.letterSpacing: 1.8;
                smooth: true
            }
            Row {
                spacing: 20
                Rectangle{
                    width:  pic1Rect.width; height: pic1Rect.height
                    BorderImage {
                        anchors {
                            fill: pic1Rect
                            leftMargin: -6; topMargin: -6; rightMargin: -6; bottomMargin: -14
                        }
                        source: 'albumRect.png'; smooth: true
                        border.left: 10; border.top: 10; border.right: 10; border.bottom: 15
                    }
                    Rectangle {
                        id: pic1Rect
                        width:  pic1.width; height: pic1.height
                        BusyIndicator { anchors.fill: parent; on: pic1.status != Image.Ready }
                        Image { id: pic1; source: url; }
                    }
                }
//                Rectangle{
//                    width:  pic2Rect.width; height: pic2Rect.height
//                    visible: pic_count>=2
//                    BorderImage {
//                        anchors {
//                            fill: pic2Rect
//                            leftMargin: -6; topMargin: -6; rightMargin: -6; bottomMargin: -14
//                        }
//                        source: '../../images/albumRect.png'; smooth: true
//                        border.left: 10; border.top: 10; border.right: 10; border.bottom: 15
//                    }
//                    Rectangle {
//                        id: pic2Rect
//                        width:  pic2.width; height: pic2.height
//                        BusyIndicator { anchors.fill: parent; on: pic2.status != Image.Ready }
//                        Image { id: pic2; source: pic_src2; }
//                    }
//                }
////                Rectangle{
////                    width:  pic3Rect.width; height: pic3Rect.height
////                    visible: pic_count>=3
////                    BorderImage {
////                        anchors {
////                            fill: pic3Rect
////                            leftMargin: -6; topMargin: -6; rightMargin: -6; bottomMargin: -14
////                        }
////                        source: 'images/albumRect.png'; smooth: true
////                        border.left: 10; border.top: 10; border.right: 10; border.bottom: 15
////                    }
////                    Rectangle {
////                        id: pic3Rect
////                        width:  pic3.width; height: pic3.height
////                        BusyIndicator { anchors.fill: parent; on: pic3.status != Image.Ready }
////                        Image { id: pic3; source: pic_src3; }
////                    }
////                }
            }

        }
//        Column {
//            id: headFeed; visible:  type == 34
//            x: 77; y: 32; width: wrapper.ListView.view.width - 95;
//            spacing: 5
//            Text {
//                text: "\u66f4\u65b0\u5934\u50cf"
//                color: "black"; wrapMode: Text.WrapAnywhere; width: parent.width;
//                font.bold: true; font.family: "宋体"; font.pixelSize: 15; font.letterSpacing: 1.8;
//                smooth: true
//            }
//            Image { id: headpic; source: "http://img.m.renren.com/gn?op=resize&w=100&h=100&p="+fid; }
//        }
        Item {
            id: replyCount; visible: true
            x: 77
            width: parent.width-20;
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 8
            height: replyNo.height
            Text {
                id: replyNo;
                text: "回复(" + comment_count + ")";
                width: parent.width;
                elide: Text.ElideRight;
                color: "#808080";
                font.pixelSize:  21
                horizontalAlignment: Text.AlignLeft;font.family: "宋体"
            }
        }

        Rectangle {
            id: lineone
            width: parent.width; height: 2; color: "#cccccc"
            anchors.bottom: parent.bottom;
            Image {
                id: lineImage
                anchors.fill: parent
                source: "line.png"
                fillMode: Image.Stretch;
            }
        }
    }




//    Item {
//        id: publish;
//        width: wrapper.ListView.view.width-20;
//        anchors.bottom: wrapper.bottom;
//        anchors.bottomMargin: 8
//        height: replyNo.height
//        Text {
//            id: publishcontent;
//            text: origin_title != undefined ? origin_title :""
//            width: parent.width;
//            elide: Text.ElideRight; color: "#808080";
//            font.pixelSize:  21
//            horizontalAlignment: Text.AlignRight;font.family: "宋体"
//        }
//    }
    //draw a line

    Item{
        id: moreItem
        anchors.fill: parent
        opacity: (id == 1 && list.hasmore?1:0)

        Text {
            id: moretext;
            text: "更多";
            anchors.centerIn: parent
            font.pixelSize:  21
            font.family: "宋体"
        }
    }


    MouseArea {
        anchors.fill: wrapper
        onClicked: {
           wrapper.ListView.view.currentIndex = index
           if(list.hasmore && (index + 1) == list.count)
           {
               console.log("more");
               wrapper.more();
           }
           else
           {
               console.log("clicked");
               wrapper.clicked(index, type)
           }
           console.log(index);
           console.log("@=" + list.count);
        }
    }
}
