import Qt 4.7
//import "../../Public"
import "SendPost.js" as SendPost

Item {
    id: guest; width: guest.ListView.view.width;
    height: status.height > 60? status.height + 60 : 100
    signal clicked(int currentItem)

    Item {
        id: guestItem
        BorderImage {
            anchors {
                fill: head
                leftMargin: -6; topMargin: -6; rightMargin: -8; bottomMargin: -8
            }
            source: 'box-shadow.png'; smooth: true
            border.left: 10; border.top: 10; border.right: 10; border.bottom: 10
        }
        Rectangle {
            id: head
            x: 11; y: 15; width: 50; height: 50;
            BusyIndicator { anchors.fill: parent; on: headImage.status != Image.Ready }
            Image {
                id: headImage; source: head_url; x: 0; y: 0
                anchors.fill:  parent; clip: true
            }
        }
        Item {
            id: nameTime
            x: 77; y: 15; width: guest.ListView.view.width - 95;
            Text {
                text: user_name; color: "#005EAC"; wrapMode: Text.WordWrap; width: parent.width;
                font.bold: true; font.pixelSize: 21
                smooth: true;font.family: "宋体"
            }
            Text { text: SendPost.getFullTime(time); font.pixelSize: 20; width: parent.width; elide: Text.ElideRight; color: "#808080"; horizontalAlignment: Text.AlignRight;font.family: "宋体" }
        }
        Column {
            id: statusFeed;
            x: 77; y: 46; width: guest.ListView.view.width - 95;
            Text {
                id: status; text: content; color:"black"; wrapMode: Text.WrapAnywhere; width: parent.width;
                font.bold: true; font.family: "宋体"; font.pixelSize: 21; font.letterSpacing: 1.8;
                smooth: true;
            }
        }
    }
    //draw a line
    Rectangle {
        id: lineone
        width: guest.width; height: 2; color: "#cccccc"
        anchors.bottom: guest.bottom;
        Image {
            id: lineImage
            anchors.fill: parent
            source: "line.png"
            fillMode: Image.Stretch;
        }
    }

    MouseArea {
        anchors.fill: parent
        onClicked: {
           guest.ListView.view.currentIndex = index
           guest.clicked(index)
           console.log(index);
        }
    }
}
