import Qt 4.7
//import "../Public"

Item{
    id: friendsItem

    width: parent.width
    height: id == 1? 60: 120

    signal clicked(int currentItem)
    signal more;

    Item{
        id: friendContent
        opacity: !moreItem.opacity
        anchors.fill: parent

        Item{
            id: friendsItemItem
            x: 20; y:20
            width: 80; height: 80;
            BorderImage {
                anchors {
                    fill: head
                    leftMargin: -6; topMargin: -6; rightMargin: -8; bottomMargin: -8
                }
                source: 'box-shadow.png'; smooth: true
                border.left: 10; border.top: 10; border.right: 10; border.bottom: 10
            }
            Rectangle {
                id: head
                anchors.fill: parent
                BusyIndicator { anchors.fill: parent; on: headImage.status != Image.Ready }
                Image {
                    id: headImage;
                    source: head_url;
                    x: 0;
                    y: 0
                    anchors.fill: parent
                    clip: true
                }
            }
        }

        Item {
            id: name
            x: friendsItemItem.x + friendsItemItem.width + 20
            y: 0
            width: parent.width - friendsItemItem.x - friendsItemItem.width
            height: parent.height

             Text {
                 anchors.verticalCenter: parent.verticalCenter
                 elide: Text.ElideRight
                 horizontalAlignment: Text.AlignHCenter
                 font.pixelSize: 21
                 font.letterSpacing: -1
                 color: "#005EAC"
                 text: user_name
                 font.family: "宋体"
                 smooth: true
             }
         }

        Rectangle {
            id: lineone
            width: parent.width; height: 2; color: "#cccccc"
            anchors.bottom: parent.bottom;
            Image {
                id: lineImage
                anchors.fill: parent
                source: "line.png"
                fillMode: Image.Stretch;
            }
        }
    }

    Item{
        id: moreItem
        anchors.fill: parent
        opacity: (id == 1 && replyListView.count > (replyListView.modelcount - 1)?1:0)

        Text {
            id: moretext;
            text: "更多";
            anchors.centerIn: parent
            font.pixelSize:  21
            font.family: "宋体"
        }
    }

    MouseArea {
        anchors.fill: parent
        onClicked: {
            friendsItem.ListView.view.currentIndex = index
            if(id == 1)
            {
                console.log("more");
                friendsItem.more();
            }
            else
            {
                console.log("clicked");
                friendsItem.clicked(index);
            }
        }
    }
}
