import Qt 4.7
//import com.nokia.meego 1.0

//Page{
//    id: flickTextEdit
//    lockInPortrait: true
//     visible: true
//     status: PageStatus.PageStatus.Active
Item{
    id:flickTextEdit
    anchors.fill: parent

    property alias text: textEdit.text
    property alias contentEdtiLine: textEdit
    clip: true
//    // add by leaf 2011.6.30
//    signal clicked

    function closeKeyBoard()
    {
        textEdit.focus = false;
        textEdit.closeSoftwareInputPanel();
    }

    Flickable {
         id: flickAble



         width: parent.width
         height: parent.height

         // 上下移动
         //contentWidth: textEdit.paintedWidth
         contentHeight: textEdit.paintedHeight
         clip: true

         function ensureVisible(r)
         {console.log(textEdit.paintedHeight)
//             if (contentX >= r.x)
//                 contentX = r.x;
//             else if (contentX+width <= r.x+r.width)
//                 contentX = r.x+r.width-width;
             if (contentY >= r.y)
                 contentY = r.y;
             else if (contentY+height <= r.y+r.height)
                 contentY = r.y+r.height-height;
         }
         TextEdit {
             id: textEdit

                // 和内容输入框进行对齐
             width: flickTextEdit.width - verticalScrollBar.width
             height: flickTextEdit.height

             font.bold: true

             // modified by leaf 2011.6.30
             font.pixelSize: 22

             focus: true
             smooth: true
             clip: true

             // 自动换行
             wrapMode: TextEdit.Wrap

             onFocusChanged:
             {
                 if(focus){
                         textEdit.openSoftwareInputPanel()
                     }
                     else{
                          textEdit.closeSoftwareInputPanel()
                     }
             }

         }
         // Only show the scrollbars when the flickAble is moving.
         states: State {
             name: "ShowBars"
             when: (flickAble.movingVertically && textEdit.paintedHeight > flickTextEdit.height)
             PropertyChanges { target: verticalScrollBar; opacity: 1 }
         }

         transitions: Transition {
             NumberAnimation { properties: "opacity"; duration: 400 }
         }
     }

     // Attach scrollbars to the right and bottom edges of the flickAble.
     Scroll {
         id: verticalScrollBar
         width: 12; height: flickAble.height
         anchors.right: flickAble.right
         opacity: 0
         orientation: Qt.Vertical
         position: flickAble.visibleArea.yPosition
         pageSize: flickAble.visibleArea.heightRatio
     }
}



