import Qt 4.7
//import "../Public"
import "SendPost.js" as SendPost
//import com.nokia.meego 1.0

//Page{
//    lockInPortrait: true
//    visible: true
//    status: PageStatus.PageStatus.Active

Item{
    id: ablum

    property variant model
    property string sessionkey: ""
    property string uid: ""
    property string aid;
    property string user_id;
    property string ablumtitle;
    property alias listmodel: ablumModel

    signal enter;
    signal getpicturelist;
    signal getMore;

    signal refresh;

    onEnter: {
        ablum.loaddata();
    }

    function loaddata()
    {
        ablum.state = "ablumlist";

        if(model.error_msg != undefined)
        {
            interact.show(model.error_msg);
            return;
        }
        ablumModel.clear();

        for ( var index in model.album_list)
            {
                ablumModel.append({
                                 "id" : model.album_list[index].id,
                                 "img" : model.album_list[index].img,
                                 "title": model.album_list[index].title,
                                 "size": model.album_list[index].size,
                                 "user_id": model.album_list[index].user_id,
                                });
            }

        replyListView.page = 1;
        replyListView.count = model.count;

        if(model.count > 10)
        {
            ablumModel.append({"id" : 1});
        }


        if(ablumModel.count == 0)
        {
            interact.show("您还没有相册");
        }
    }

    onRefresh: {
        function getAblum() {}

        getAblum.prototype = {
            update: function(a)
                    {
                        interact.closeBusy();
                        ablum.model = a;
                        ablum.enter();
                    }
        }
        SendPost.getAblums(mainview.sessionkey, mainview.uid, 1, new getAblum());
        interact.showBusy("数据加载中,请稍候...");
    }

    onGetMore: {
        function getAblum() {}

        getAblum.prototype = {
            update: function(a)
                    {
                        var isHave = 0;

                        interact.closeBusy();

                        if(a.error_msg != undefined)
                        {
                            interact.show(a.error_msg);
                            return;
                        }

                        for ( var index in a.album_list)
                            {
                            isHave = 1;

                            ablumModel.insert((ablumModel.count - 1), {
                                                 "id" : a.album_list[index].id,
                                                 "img" : a.album_list[index].img,
                                                 "title": a.album_list[index].title,
                                                 "size": a.album_list[index].size,
                                                 "user_id": a.album_list[index].user_id,
                                                });
                            }

                        if(a.count == (ablumModel.count - 1))
                        {
                            interact.show("没有相册了");
                            ablumModel.remove(ablumModel.count - 1);
                            return;
                        }

                        if(isHave == 1)
                        {
                            replyListView.page++;
                        }
                    }
        }
        SendPost.getAblums(mainview.sessionkey, mainview.uid, replyListView.page + 1, new getAblum());
        interact.showBusy("数据加载中,请稍候...");
    }

    onGetpicturelist: {
        function getpictureList(){}

        getpictureList.prototype = {
            update:function(a)
                   {
                       interact.closeBusy();

                       pictureModel.clear();
                       for ( var index in a.photo_list)
                           {
                               pictureModel.append({
                                                "id" : a.photo_list[index].id,
                                                "user_name": a.photo_list[index].user_name,
                                                "img_head": a.photo_list[index].img_head,
                                                "time": a.photo_list[index].time,
                                                "user_id":a.photo_list[index].user_id,
                                                "img_large":a.photo_list[index].img_large,
                                                "caption":a.photo_list[index].caption,
                                                "album_id":a.photo_list[index].album_id,
                                                "user_id":a.photo_list[index].user_id,
                                             });
                           console.log("&&&&");
                           }
                       console.log("enter ablumgrid");
                       console.log("count = " + pictureModel.count);
                       ablum.state = "ablumgrid";

                       if(a.error_msg != undefined)
                       {
                           interact.show(a.error_msg);
                           return;
                       }

                       if(pictureModel.count == 0)
                       {
                           interact.show("没有照片");
                           return;
                       }
                   }

        }
        SendPost.getPictureList(sessionkey, user_id, aid, new getpictureList());
        interact.showBusy("数据加载中,请稍候...");
    }

    Rectangle { id: photosShade; color: 'black'; width: parent.width; height: parent.height; opacity: 0}


    Item{
        id: top
        width:parent.width
        height: 80

        property  alias text: midtext.text

        Image {
            id: headbg1
            anchors.fill:  parent
            source: "headbg.png"
        }

        Item{
            id: midtextbg
            width: parent.width - back.width - refresh.width - 60
            anchors.centerIn: parent
            Text {
                id: midtext
                width: parent.width
                anchors.centerIn: parent
                horizontalAlignment: Text.AlignHCenter
                elide: Text.ElideRight
                font.letterSpacing: -1
                color: "white"
                font.bold: true
                font.pixelSize: 26
                font.family: "宋体"
            }
        }

        MyButton { // log in
           id: back
           x:  20
           width: 80
           height: 50
           opacity: 1
           anchors.verticalCenter: parent.verticalCenter
           anchors.left: parent.left
           anchors.leftMargin: 20
           text: "  返回"
           keyUsing: true;
           imagesource: "return.sci"
           presssource: "return_press.png"
           onClicked:
           {
               if(ablum.state == "ablumlist")
               {
                   mainview.state = "";
               }
               else if(ablum.state == "ablumgrid")
               {
                   ablum.state = "ablumlist";
               }
               else if(ablum.state == "picturelist")
               {
                   ablum.state = "ablumgrid";
               }
           }
        }

        MyButton { // log in
           id: refresh
           x:  20
           width: 50
           height: 46
           opacity: 1
           anchors.verticalCenter: parent.verticalCenter
           anchors.right: parent.right
           anchors.rightMargin: 20
           keyUsing: true;
           imagesource: "refresh.png"
           presssource: "refresh_press.png"
           onClicked:
           {
//               ablum.refresh();
           }
        }

        states: [
            State {
                name: "ablumlist"
                when: ablum.state == "ablumlist"
                PropertyChanges {target: headbg1; source: "headbg.png"}
                PropertyChanges {target: back; imagesource: "return.png"}
                PropertyChanges {target: refresh; opacity: 1}
            },
            State {
                name: "ablumgrid"
                when: ablum.state == "ablumgrid"
                PropertyChanges {target: headbg1; source: "blackhead.png"}
                PropertyChanges {target: back; imagesource: "blackreturn.png"}
                PropertyChanges {target: refresh; opacity: 0}
            },
            State {
                name: "picturelist"
                when: ablum.state == "picturelist"
                PropertyChanges {target: headbg1; source: "blackhead.png"}
                PropertyChanges {target: back; imagesource: "blackreturn.png"}
                PropertyChanges {target: refresh; opacity: 0}
            },
            State {
                name: "hide"
                when: ablum.state == "hide"
                PropertyChanges {target: top; opacity: 0}
                PropertyChanges {target: refresh; opacity: 0}
            }
        ]

        transitions: [
            Transition { NumberAnimation { properties: "x,y,opacity"; duration: 500; easing.type: Easing.InOutQuad } }
            ]
    }


    ListModel{id: pictureModel}

    Item{
        id : picturelistmid

        x: 0
        y: top.height
        width: parent.width
        height: parent.height - top.height - bottomItem.height

        ListView {
            id: photosListView;
            model: pictureModel;
            orientation: Qt.Horizontal
            x: 0
            y: 0
            width: parent.width; height: parent.height;
            clip: true
            snapMode: ListView.SnapOneItem
            onCurrentIndexChanged: ablumgridView.positionViewAtIndex(currentIndex, GridView.Contain)
            highlightRangeMode: ListView.StrictlyEnforceRange;
            highlightMoveSpeed:100000

            delegate: PictureListDelegate {
                onClicked: {
                    if(ablum.state == "picturelist")
                    {
                        ablum.state = "hide";
                    }
                    else
                    {
                        ablum.state = "picturelist";
                    }
                }
            }
         }
    }

    Item{
        id : ablumlistmid

        width: parent.width
        height: parent.height - top.height
        y: top.height

        ListModel{id: ablumModel}

        ListView {
            id: replyListView
            anchors.fill: parent
            clip: true
            model: ablumModel
            property int page: 1
            property alias modelcount:ablumModel.count
            property int count;
            delegate: AblumListDelegate {
                onClicked: {
                     console.log("clicked");
                     ablum.aid = replyListView.model.get(currentItem).id;
                     ablum.user_id = replyListView.model.get(currentItem).user_id;
                     ablum.ablumtitle = replyListView.model.get(currentItem).title;
                     pictureModel.clear();
                     ablum.getpicturelist();
                }
                onMore:{
                    ablum.getMore();
                }
            }
         }
    }

    Item{
        id : ablumgridmid

        width: parent.width
        height: parent.height - top.height
        x: 0
        y: top.height

        GridView {
            id: ablumgridView
            anchors.fill: parent
            clip: true
            model: pictureModel
            cellWidth: 117; cellHeight: 100
            onCurrentIndexChanged: photosListView.positionViewAtIndex(currentIndex, ListView.Contain)
            delegate: AblumGridDelegate {
                onClicked: {
                    ablum.state = "picturelist"
                }
            }
         }
    }

    states: [
        State {
            name: "ablumlist"
            PropertyChanges {target: top; opacity: 1; text: "相册"}
            PropertyChanges {target: picturelistmid; opacity: 0;}
            PropertyChanges {target: ablumgridmid; opacity: 0;}
            PropertyChanges {target: ablumlistmid; opacity: 1;}
            PropertyChanges {target: photosShade; opacity: 0;}
        }
        ,
        State {
            name: "ablumgrid"
            PropertyChanges {target: top; opacity: 1; text: ablum.ablumtitle}
            PropertyChanges {target: photosShade; opacity: 1;}
            PropertyChanges {target: ablumgridmid; opacity: 1;}
            PropertyChanges {target: picturelistmid; opacity: 0;}
            PropertyChanges {target: ablumlistmid; opacity: 0;}
        },
        State {
            name: "picturelist"
            PropertyChanges {target: top; opacity: 1; text: "相册"}
            PropertyChanges {target: photosShade; opacity: 1;}
            PropertyChanges {target: ablumgridmid; opacity: 0;}
            PropertyChanges {target: ablumlistmid; opacity: 0;}
            PropertyChanges {target: picturelistmid; opacity: 1;}
        },
        State {
            name: "hide"
            PropertyChanges {target: top; opacity: 0; text: "相册"}
            PropertyChanges {target: photosShade; opacity: 1;}
            PropertyChanges {target: ablumgridmid; opacity: 0;}
            PropertyChanges {target: ablumlistmid; opacity: 0;}
            PropertyChanges {target: picturelistmid; opacity: 1;}
        }
            ]
    transitions: [
        Transition { NumberAnimation { properties: "x,y,opacity"; duration: 500; easing.type: Easing.InOutQuad } }
        ]
}
