/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadAbortMonitor;
import org.gjt.sp.util.WorkThreadPool;

public class WorkThread
extends Thread
implements ThreadAbortMonitor {
    private WorkThreadPool pool;
    private final Object abortLock = new Object();
    private boolean requestRunning;
    private boolean abortable;
    private boolean aborted;
    private String status;
    private int progressValue;
    private int progressMaximum;

    public WorkThread(WorkThreadPool pool, ThreadGroup group, String name) {
        super(group, name);
        this.setPriority(1);
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAbortable(boolean abortable) {
        Object object = this.abortLock;
        synchronized (object) {
            this.abortable = abortable;
            if (this.aborted) {
                this.stop(new Abort());
            }
        }
    }

    public boolean isRequestRunning() {
        return this.requestRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAborted() {
        Object object = this.abortLock;
        synchronized (object) {
            return this.aborted;
        }
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
        this.pool.fireProgressChanged(this);
    }

    public int getProgressValue() {
        return this.progressValue;
    }

    public void setProgressValue(int progressValue) {
        this.progressValue = progressValue;
        this.pool.fireProgressChanged(this);
    }

    public int getProgressMaximum() {
        return this.progressMaximum;
    }

    public void setProgressMaximum(int progressMaximum) {
        this.progressMaximum = progressMaximum;
        this.pool.fireProgressChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortCurrentRequest() {
        Object object = this.abortLock;
        synchronized (object) {
            if (this.abortable && !this.aborted) {
                this.stop(new Abort());
            }
            this.aborted = true;
        }
    }

    public void run() {
        Log.log(1, this, "Work request thread starting [" + this.getName() + "]");
        while (true) {
            this.doRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequests() {
        WorkThreadPool.Request request;
        while ((request = this.pool.getNextRequest()) != null) {
            this.requestRunning = true;
            this.pool.fireStatusChanged(this);
            this.doRequest(request);
            this.requestRunning = false;
        }
        this.pool.fireStatusChanged(this);
        Object object = this.pool.waitForAllLock;
        synchronized (object) {
            this.pool.waitForAllLock.notifyAll();
        }
        object = this.pool.lock;
        synchronized (object) {
            try {
                this.pool.lock.wait();
            }
            catch (InterruptedException ie) {
                Log.log(9, this, ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(WorkThreadPool.Request request) {
        Log.log(1, WorkThread.class, "Running in work thread: " + request);
        try {
            request.run.run();
        }
        catch (Abort a) {
            Log.log(9, WorkThread.class, "Unhandled abort", a);
        }
        catch (Throwable t) {
            Log.log(9, WorkThread.class, "Exception in work thread: ", t);
        }
        finally {
            Object a = this.abortLock;
            synchronized (a) {
                this.abortable = false;
                this.aborted = false;
            }
            this.status = null;
            this.progressMaximum = 0;
            this.progressValue = 0;
            this.pool.requestDone();
            this.pool.fireStatusChanged(this);
        }
    }

    public static class Abort
    extends Error {
        public Abort() {
            super("Work request aborted");
        }
    }
}

