/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaException;

public class JEditTextArea
extends TextArea {
    private View view;
    private JPopupMenu popup;
    private boolean popupEnabled;

    public JEditTextArea(View view) {
        super((IPropertyManager)jEdit.getPropertyManager(), view);
        this.enableEvents(12L);
        this.popupEnabled = true;
        this.view = view;
    }

    public void smartHome(boolean select) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.view.getInputHandler().getLastActionCount()) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfWhiteSpace(" + select + ");");
                }
                this.goToStartOfWhiteSpace(select);
                break;
            }
            case 2: {
                if (recorder != null) {
                    recorder.record("textArea.goToStartOfLine(" + select + ");");
                }
                this.goToStartOfLine(select);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToFirstVisibleLine(" + select + ");");
                }
                this.goToFirstVisibleLine(select);
            }
        }
    }

    public void smartEnd(boolean select) {
        Macros.Recorder recorder = this.view.getMacroRecorder();
        switch (this.view.getInputHandler().getLastActionCount()) {
            case 1: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfWhiteSpace(" + select + ");");
                }
                this.goToEndOfWhiteSpace(select);
                break;
            }
            case 2: {
                if (recorder != null) {
                    recorder.record("textArea.goToEndOfLine(" + select + ");");
                }
                this.goToEndOfLine(select);
                break;
            }
            default: {
                if (recorder != null) {
                    recorder.record("textArea.goToLastVisibleLine(" + select + ");");
                }
                this.goToLastVisibleLine(select);
            }
        }
    }

    public void goToBufferEnd(boolean select) {
        EditBus.send(new PositionChanging(this));
        super.goToBufferEnd(select);
    }

    public void goToBufferStart(boolean select) {
        EditBus.send(new PositionChanging(this));
        super.goToBufferStart(select);
    }

    public void showGoToLineDialog() {
        String line = GUIUtilities.input(this.view, "goto-line", null);
        if (line == null) {
            return;
        }
        try {
            int lineNumber = Integer.parseInt(line) - 1;
            this.setCaretPosition(this.getLineStartOffset(lineNumber));
        }
        catch (Exception e) {
            this.getToolkit().beep();
        }
    }

    public void userInput(char ch) {
        if (ch == ' ' && Abbrevs.getExpandOnInput() && Abbrevs.expandAbbrev(this.view, false)) {
            return;
        }
        super.userInput(ch);
    }

    public void addExplicitFold() {
        try {
            super.addExplicitFold();
        }
        catch (TextAreaException e) {
            GUIUtilities.error(this.view, "folding-not-explicit", null);
        }
    }

    public void formatParagraph() {
        try {
            super.formatParagraph();
        }
        catch (TextAreaException e) {
            GUIUtilities.error(this.view, "format-maxlinelen", null);
        }
    }

    protected static void doWordCount(View view, String text) {
        char[] chars = text.toCharArray();
        int characters = chars.length;
        int words = 0;
        int lines = 1;
        boolean word = true;
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\n': 
                case '\r': {
                    ++lines;
                }
                case '\t': 
                case ' ': {
                    word = true;
                    continue block4;
                }
                default: {
                    if (!word) continue block4;
                    ++words;
                    word = false;
                }
            }
        }
        Object[] args = new Object[]{characters, words, lines};
        GUIUtilities.message(view, "wordcount", args);
    }

    public void showWordCountDialog() {
        String selection = this.getSelectedText();
        if (selection != null) {
            JEditTextArea.doWordCount(this.view, selection);
            return;
        }
        JEditTextArea.doWordCount(this.view, this.buffer.getText(0, this.buffer.getLength()));
    }

    public View getView() {
        return this.view;
    }

    @Deprecated
    public final int getSelectionStart() {
        if (this.getSelectionCount() != 1) {
            return this.caret;
        }
        return this.getSelection(0).getStart();
    }

    @Deprecated
    public int getSelectionStart(int line) {
        if (this.getSelectionCount() != 1) {
            return this.caret;
        }
        return this.getSelection(0).getStart(this.buffer, line);
    }

    @Deprecated
    public final int getSelectionStartLine() {
        if (this.getSelectionCount() != 1) {
            return this.caret;
        }
        return this.getSelection(0).getStartLine();
    }

    @Deprecated
    public final void setSelectionStart(int selectionStart) {
        int selectionEnd = this.getSelectionCount() == 1 ? this.getSelection(0).getEnd() : this.caret;
        this.setSelection(new Selection.Range(selectionStart, selectionEnd));
        this.moveCaretPosition(selectionEnd, true);
    }

    @Deprecated
    public final int getSelectionEnd() {
        return this.getSelectionCount() == 1 ? this.getSelection(0).getEnd() : this.caret;
    }

    @Deprecated
    public int getSelectionEnd(int line) {
        if (this.getSelectionCount() != 1) {
            return this.caret;
        }
        return this.getSelection(0).getEnd(this.buffer, line);
    }

    @Deprecated
    public final int getSelectionEndLine() {
        if (this.getSelectionCount() != 1) {
            return this.caret;
        }
        return this.getSelection(0).getEndLine();
    }

    @Deprecated
    public final void setSelectionEnd(int selectionEnd) {
        int selectionStart = this.getSelectionCount() == 1 ? this.getSelection(0).getStart() : this.caret;
        this.setSelection(new Selection.Range(selectionStart, selectionEnd));
        this.moveCaretPosition(selectionEnd, true);
    }

    @Deprecated
    public void select(int start, int end) {
        this.setSelection(new Selection.Range(start, end));
        this.moveCaretPosition(end, true);
    }

    @Deprecated
    public void select(int start, int end, boolean doElectricScroll) {
        int newEnd;
        int newStart;
        this.selectNone();
        if (start < end) {
            newStart = start;
            newEnd = end;
        } else {
            newStart = end;
            newEnd = start;
        }
        this.setSelection(new Selection.Range(newStart, newEnd));
        this.moveCaretPosition(end, doElectricScroll);
    }

    @Deprecated
    public boolean isSelectionRectangular() {
        Selection s = this.getSelectionAtOffset(this.caret);
        return s != null && s instanceof Selection.Rect;
    }

    public boolean isRightClickPopupEnabled() {
        return this.popupEnabled;
    }

    public void setRightClickPopupEnabled(boolean popupEnabled) {
        this.popupEnabled = popupEnabled;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public void handlePopupTrigger(MouseEvent evt) {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else {
            this.popup = GUIUtilities.loadPopupMenu("view.context", this, evt);
            int x = evt.getX();
            int y = evt.getY();
            int dragStart = this.xyToOffset(x, y, !this.painter.isBlockCaretEnabled() && !this.isOverwriteEnabled());
            if (this.getSelectionCount() == 0 || this.multi) {
                this.moveCaretPosition(dragStart, false);
            }
            GUIUtilities.showPopupMenu(this.popup, this.painter, x, y);
        }
    }

    public void showPopupMenu() {
        Point caretPos;
        if (!this.popup.isVisible() && this.hasFocus() && (caretPos = this.offsetToXY(this.getCaretPosition())) != null) {
            int charHeight = this.getPainter().getFontMetrics().getHeight();
            GUIUtilities.showPopupMenu(this.popup, this.painter, caretPos.x, caretPos.y + charHeight, true);
        }
    }
}

