/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

abstract class Anchor {
    protected final DisplayManager displayManager;
    protected final TextArea textArea;
    int physicalLine;
    int scrollLine;
    boolean callChanged;
    boolean callReset;

    protected Anchor(DisplayManager displayManager, TextArea textArea) {
        this.displayManager = displayManager;
        this.textArea = textArea;
    }

    abstract void reset();

    abstract void changed();

    public String toString() {
        return this.getClass().getName() + '[' + this.physicalLine + ',' + this.scrollLine + ']';
    }

    void contentInserted(int startLine, int numLines) {
        if (this.physicalLine >= startLine) {
            if (this.physicalLine != startLine) {
                this.physicalLine += numLines;
            }
            this.callChanged = true;
        }
    }

    void preContentRemoved(int startLine, int offset, int numLines) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "preContentRemoved() before:" + this);
        }
        if (this.physicalLine >= startLine) {
            if (this.physicalLine == startLine) {
                this.callChanged = true;
            } else {
                int end = Math.min(startLine + numLines, this.physicalLine);
                for (int i = startLine + 1; i <= end; ++i) {
                    if (!this.displayManager.isLineVisible(i)) continue;
                    this.scrollLine -= this.displayManager.screenLineMgr.getScreenLineCount(i);
                }
                this.physicalLine -= end - startLine;
                this.callChanged = true;
            }
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "preContentRemoved() after:" + this);
        }
    }
}

