/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.util.StandardUtilities;

public abstract class BufferListSet
implements SearchFileSet {
    private String[] files;

    public synchronized String getFirstFile(View view) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files[0];
    }

    public synchronized String getNextFile(View view, String path) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        if (path == null) {
            path = view.getBuffer().getSymlinkPath();
            VFS vfs = VFSManager.getVFSForPath(path);
            boolean ignoreCase = (vfs.getCapabilities() & 0x80) != 0;
            for (int i = 0; i < this.files.length; ++i) {
                if (StandardUtilities.compareStrings(this.files[i], path, ignoreCase) != 0) continue;
                return path;
            }
            return this.getFirstFile(view);
        }
        VFS vfs = VFSManager.getVFSForPath(path);
        boolean ignoreCase = (vfs.getCapabilities() & 0x80) != 0;
        for (int i = 0; i < this.files.length - 1; ++i) {
            if (StandardUtilities.compareStrings(this.files[i], path, ignoreCase) != 0) continue;
            return this.files[i + 1];
        }
        return null;
    }

    public synchronized String[] getFiles(View view) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files;
    }

    public synchronized int getFileCount(View view) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null) {
            return 0;
        }
        return this.files.length;
    }

    public String getCode() {
        return null;
    }

    public void invalidateCachedList() {
        this.files = null;
    }

    protected abstract String[] _getFiles(Component var1);
}

