/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class StatusBarOptionPane
extends AbstractOptionPane {
    private ColorWellButton foregroundColor;
    private ColorWellButton backgroundColor;
    private ColorWellButton memForegroundColor;
    private ColorWellButton memBackgroundColor;
    private JCheckBox showStatusbar;
    private JCheckBox showStatusbarPlain;
    private DefaultListModel listModel;
    private JList list;
    private RolloverButton add;
    private RolloverButton remove;
    private RolloverButton moveUp;
    private RolloverButton moveDown;
    private RolloverButton edit;

    public StatusBarOptionPane() {
        super("status");
    }

    protected void _init() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(2, 1));
        this.showStatusbar = new JCheckBox(jEdit.getProperty("options.status.visible"));
        this.showStatusbar.setSelected(jEdit.getBooleanProperty("view.status.visible"));
        panel.add(this.showStatusbar);
        this.showStatusbarPlain = new JCheckBox(jEdit.getProperty("options.status.plainview.visible"));
        this.showStatusbarPlain.setSelected(jEdit.getBooleanProperty("view.status.plainview.visible"));
        panel.add(this.showStatusbarPlain);
        panel.add(new JLabel(jEdit.getProperty("options.status.caption")));
        this.add((Component)panel, "North");
        AbstractOptionPane optionsPanel = new AbstractOptionPane("Status Options");
        this.foregroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.foreground"));
        optionsPanel.addComponent(jEdit.getProperty("options.status.foreground"), (Component)this.foregroundColor, 3);
        this.backgroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.background"));
        optionsPanel.addComponent(jEdit.getProperty("options.status.background"), (Component)this.backgroundColor, 3);
        this.memForegroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.memory.foreground"));
        optionsPanel.addComponent(jEdit.getProperty("options.status.memory.foreground"), (Component)this.memForegroundColor, 3);
        this.memBackgroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.memory.background"));
        optionsPanel.addComponent(jEdit.getProperty("options.status.memory.background"), (Component)this.memBackgroundColor, 3);
        String statusbar = jEdit.getProperty("view.status");
        StringTokenizer st = new StringTokenizer(statusbar);
        this.listModel = new DefaultListModel();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.listModel.addElement(token);
        }
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListHandler());
        JPanel widgetsPanel = new JPanel(new BorderLayout());
        widgetsPanel.add((Component)new JScrollPane(this.list), "Center");
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(3, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        ActionHandler actionHandler = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon("Plus.png"));
        this.add.setToolTipText(jEdit.getProperty("options.status.add"));
        this.add.addActionListener(actionHandler);
        buttons.add(this.add);
        buttons.add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon("Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty("options.status.remove"));
        this.remove.addActionListener(actionHandler);
        buttons.add(this.remove);
        buttons.add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon("ArrowU.png"));
        this.moveUp.setToolTipText(jEdit.getProperty("options.status.moveUp"));
        this.moveUp.addActionListener(actionHandler);
        buttons.add(this.moveUp);
        buttons.add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon("ArrowD.png"));
        this.moveDown.setToolTipText(jEdit.getProperty("options.status.moveDown"));
        this.moveDown.addActionListener(actionHandler);
        buttons.add(this.moveDown);
        buttons.add(Box.createHorizontalStrut(6));
        this.edit = new RolloverButton(GUIUtilities.loadIcon("ButtonProperties.png"));
        this.edit.setToolTipText(jEdit.getProperty("options.status.edit"));
        this.edit.addActionListener(actionHandler);
        buttons.add(this.edit);
        buttons.add(Box.createGlue());
        this.updateButtons();
        widgetsPanel.add((Component)buttons, "South");
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Options", optionsPanel);
        tabs.add("Widgets", widgetsPanel);
        this.add((Component)tabs, "Center");
    }

    protected void _save() {
        jEdit.setColorProperty("view.status.foreground", this.foregroundColor.getSelectedColor());
        jEdit.setColorProperty("view.status.background", this.backgroundColor.getSelectedColor());
        jEdit.setColorProperty("view.status.memory.foreground", this.memForegroundColor.getSelectedColor());
        jEdit.setColorProperty("view.status.memory.background", this.memBackgroundColor.getSelectedColor());
        jEdit.setBooleanProperty("view.status.visible", this.showStatusbar.isSelected());
        jEdit.setBooleanProperty("view.status.plainview.visible", this.showStatusbarPlain.isSelected());
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i != 0) {
                buf.append(' ');
            }
            String widgetName = (String)this.listModel.elementAt(i);
            buf.append(widgetName);
        }
        jEdit.setProperty("view.status", buf.toString());
    }

    private void updateButtons() {
        int index = this.list.getSelectedIndex();
        this.remove.setEnabled(index != -1 && this.listModel.getSize() != 0);
        this.moveUp.setEnabled(index > 0);
        this.moveDown.setEnabled(index != -1 && index != this.listModel.getSize() - 1);
        this.edit.setEnabled(index != -1);
    }

    private class WidgetSelectionDialog
    extends EnhancedDialog {
        private JButton ok;
        private JButton cancel;
        private JTextField labelField;
        private JLabel labelLabel;
        private JRadioButton labelRadio;
        private JComboBox widgetCombo;
        private JLabel widgetLabel;
        private JRadioButton widgetRadio;
        private String value;

        WidgetSelectionDialog(Component comp) {
            super(GUIUtilities.getParentDialog(comp), jEdit.getProperty("options.status.edit.title"), true);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.labelRadio = new JRadioButton(jEdit.getProperty("options.status.edit.labelRadioButton"));
            this.widgetRadio = new JRadioButton(jEdit.getProperty("options.status.edit.widgetRadioButton"));
            buttonGroup.add(this.labelRadio);
            buttonGroup.add(this.widgetRadio);
            this.labelLabel = new JLabel(jEdit.getProperty("options.status.edit.labelLabel"));
            this.labelField = new JTextField();
            this.widgetLabel = new JLabel(jEdit.getProperty("options.status.edit.widgetLabel"));
            this.widgetCombo = new JComboBox<String>(ServiceManager.getServiceNames("org.gjt.sp.jedit.gui.statusbar.StatusWidget"));
            ActionHandler actionHandler = new ActionHandler();
            this.labelRadio.addActionListener(actionHandler);
            this.widgetRadio.addActionListener(actionHandler);
            JPanel southPanel = new JPanel();
            southPanel.setLayout(new BoxLayout(southPanel, 0));
            southPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
            southPanel.add(Box.createGlue());
            this.ok = new JButton(jEdit.getProperty("common.ok"));
            this.ok.addActionListener(actionHandler);
            this.getRootPane().setDefaultButton(this.ok);
            southPanel.add(this.ok);
            southPanel.add(Box.createHorizontalStrut(6));
            this.cancel = new JButton(jEdit.getProperty("common.cancel"));
            this.cancel.addActionListener(actionHandler);
            southPanel.add(this.cancel);
            southPanel.add(Box.createGlue());
            this.labelField.setEnabled(false);
            this.widgetRadio.setSelected(true);
            JPanel content = new JPanel(new BorderLayout());
            content.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.setContentPane(content);
            JPanel center = new JPanel();
            center.setLayout(new BoxLayout(center, 1));
            center.add(this.labelRadio);
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)this.labelLabel, "West");
            p.add(this.labelField);
            center.add(p);
            center.add(this.widgetRadio);
            p = new JPanel(new BorderLayout());
            p.add((Component)this.widgetLabel, "West");
            p.add(this.widgetCombo);
            center.add(p);
            this.getContentPane().add((Component)center, "Center");
            this.getContentPane().add((Component)southPanel, "South");
            this.pack();
            this.setLocationRelativeTo(GUIUtilities.getParentDialog(comp));
            this.setVisible(true);
        }

        public void ok() {
            this.value = this.widgetRadio.isSelected() ? (String)this.widgetCombo.getSelectedItem() : this.labelField.getText().trim();
            this.dispose();
        }

        public void cancel() {
            this.value = null;
            this.dispose();
        }

        public String getValue() {
            return this.value;
        }

        private class ActionHandler
        implements ActionListener {
            private ActionHandler() {
            }

            public void actionPerformed(ActionEvent evt) {
                Object source = evt.getSource();
                if (source == WidgetSelectionDialog.this.ok) {
                    WidgetSelectionDialog.this.ok();
                } else if (source == WidgetSelectionDialog.this.cancel) {
                    WidgetSelectionDialog.this.cancel();
                } else if (source == WidgetSelectionDialog.this.labelRadio) {
                    WidgetSelectionDialog.this.labelField.setEnabled(true);
                    WidgetSelectionDialog.this.widgetCombo.setEnabled(false);
                    WidgetSelectionDialog.this.validate();
                } else if (source == WidgetSelectionDialog.this.widgetRadio) {
                    WidgetSelectionDialog.this.labelField.setEnabled(false);
                    WidgetSelectionDialog.this.widgetCombo.setEnabled(true);
                    WidgetSelectionDialog.this.validate();
                }
            }
        }
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            StatusBarOptionPane.this.updateButtons();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == StatusBarOptionPane.this.add) {
                String value = this.selectWidget();
                if (value == null) {
                    return;
                }
                int index = StatusBarOptionPane.this.list.getSelectedIndex();
                index = index == -1 ? StatusBarOptionPane.this.listModel.getSize() : ++index;
                StatusBarOptionPane.this.listModel.insertElementAt(value, index);
                StatusBarOptionPane.this.list.setSelectedIndex(index);
                StatusBarOptionPane.this.list.ensureIndexIsVisible(index);
            } else if (source == StatusBarOptionPane.this.remove) {
                int index = StatusBarOptionPane.this.list.getSelectedIndex();
                StatusBarOptionPane.this.listModel.removeElementAt(index);
                if (StatusBarOptionPane.this.listModel.getSize() != 0) {
                    if (StatusBarOptionPane.this.listModel.getSize() == index) {
                        StatusBarOptionPane.this.list.setSelectedIndex(index - 1);
                    } else {
                        StatusBarOptionPane.this.list.setSelectedIndex(index);
                    }
                }
                StatusBarOptionPane.this.updateButtons();
            } else if (source == StatusBarOptionPane.this.moveUp) {
                int index = StatusBarOptionPane.this.list.getSelectedIndex();
                Object selected = StatusBarOptionPane.this.list.getSelectedValue();
                StatusBarOptionPane.this.listModel.removeElementAt(index);
                StatusBarOptionPane.this.listModel.insertElementAt(selected, index - 1);
                StatusBarOptionPane.this.list.setSelectedIndex(index - 1);
                StatusBarOptionPane.this.list.ensureIndexIsVisible(index - 1);
            } else if (source == StatusBarOptionPane.this.moveDown) {
                int index = StatusBarOptionPane.this.list.getSelectedIndex();
                Object selected = StatusBarOptionPane.this.list.getSelectedValue();
                StatusBarOptionPane.this.listModel.removeElementAt(index);
                StatusBarOptionPane.this.listModel.insertElementAt(selected, index + 1);
                StatusBarOptionPane.this.list.setSelectedIndex(index + 1);
                StatusBarOptionPane.this.list.ensureIndexIsVisible(index + 1);
            } else if (source == StatusBarOptionPane.this.edit) {
                String value = this.selectWidget();
                if (value == null) {
                    return;
                }
                int index = StatusBarOptionPane.this.list.getSelectedIndex();
                StatusBarOptionPane.this.listModel.insertElementAt(value, index);
                StatusBarOptionPane.this.list.setSelectedIndex(index);
                StatusBarOptionPane.this.list.ensureIndexIsVisible(index);
            }
        }

        private String selectWidget() {
            WidgetSelectionDialog dialog = new WidgetSelectionDialog(StatusBarOptionPane.this);
            String value = dialog.getValue();
            if (value != null && value.length() == 0) {
                value = null;
            }
            return value;
        }
    }
}

