/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.BrowserColorsModel;

public class BrowserColorsOptionPane
extends AbstractOptionPane {
    private BrowserColorsModel colorsModel;
    private JTable colorsTable;
    private JButton add;
    private JButton remove;
    private JButton moveUp;
    private JButton moveDown;

    public BrowserColorsOptionPane() {
        super("browser.colors");
    }

    protected void _init() {
        this.setLayout(new BorderLayout());
        this.colorsModel = new BrowserColorsModel();
        this.colorsTable = new JTable(this.colorsModel);
        this.colorsTable.setAutoResizeMode(4);
        this.colorsTable.getTableHeader().setReorderingAllowed(false);
        this.colorsTable.addMouseListener(new MouseHandler());
        this.colorsTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        TableColumnModel tcm = this.colorsTable.getColumnModel();
        tcm.getColumn(1).setCellRenderer(new BrowserColorsModel.ColorRenderer());
        Dimension d = this.colorsTable.getPreferredSize();
        d.height = Math.min(d.height, 200);
        JScrollPane scroller = new JScrollPane(this.colorsTable);
        scroller.setPreferredSize(d);
        this.add("Center", scroller);
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(3, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        ActionHandler actionHandler = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon("Plus.png"));
        this.add.setToolTipText(jEdit.getProperty("common.add"));
        this.add.addActionListener(actionHandler);
        buttons.add(this.add);
        buttons.add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon("Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty("common.remove"));
        this.remove.addActionListener(actionHandler);
        buttons.add(this.remove);
        buttons.add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon("ArrowU.png"));
        this.moveUp.setToolTipText(jEdit.getProperty("common.moveUp"));
        this.moveUp.addActionListener(actionHandler);
        buttons.add(this.moveUp);
        buttons.add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon("ArrowD.png"));
        this.moveDown.setToolTipText(jEdit.getProperty("common.moveDown"));
        this.moveDown.addActionListener(actionHandler);
        buttons.add(this.moveDown);
        buttons.add(Box.createGlue());
        this.add("South", buttons);
        this.updateEnabled();
    }

    protected void _save() {
        this.colorsModel.save();
    }

    private void updateEnabled() {
        int selectedRow = this.colorsTable.getSelectedRow();
        this.remove.setEnabled(selectedRow != -1);
        this.moveUp.setEnabled(selectedRow > 0);
        this.moveUp.setEnabled(selectedRow != -1 && selectedRow != this.colorsModel.getRowCount());
    }

    private void setSelectedRow(int row) {
        this.colorsTable.getSelectionModel().setSelectionInterval(row, row);
        this.colorsTable.scrollRectToVisible(this.colorsTable.getCellRect(row, 0, true));
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            Point p = evt.getPoint();
            int row = BrowserColorsOptionPane.this.colorsTable.rowAtPoint(p);
            int column = BrowserColorsOptionPane.this.colorsTable.columnAtPoint(p);
            if (row == -1 || column != 1) {
                return;
            }
            Color color = JColorChooser.showDialog(BrowserColorsOptionPane.this, jEdit.getProperty("colorChooser.title"), (Color)BrowserColorsOptionPane.this.colorsModel.getValueAt(row, 1));
            if (color != null) {
                BrowserColorsOptionPane.this.colorsModel.setValueAt(color, row, 1);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == BrowserColorsOptionPane.this.add) {
                BrowserColorsOptionPane.this.colorsModel.add();
            } else if (source == BrowserColorsOptionPane.this.remove) {
                int selectedRow = BrowserColorsOptionPane.this.colorsTable.getSelectedRow();
                BrowserColorsOptionPane.this.colorsModel.remove(selectedRow);
                BrowserColorsOptionPane.this.updateEnabled();
            } else if (source == BrowserColorsOptionPane.this.moveUp) {
                int selectedRow = BrowserColorsOptionPane.this.colorsTable.getSelectedRow();
                if (selectedRow != 0) {
                    BrowserColorsOptionPane.this.colorsModel.moveUp(selectedRow);
                    BrowserColorsOptionPane.this.setSelectedRow(selectedRow - 1);
                }
                BrowserColorsOptionPane.this.updateEnabled();
            } else if (source == BrowserColorsOptionPane.this.moveDown) {
                int selectedRow = BrowserColorsOptionPane.this.colorsTable.getSelectedRow();
                if (selectedRow != BrowserColorsOptionPane.this.colorsTable.getRowCount() - 1) {
                    BrowserColorsOptionPane.this.colorsModel.moveDown(selectedRow);
                    BrowserColorsOptionPane.this.setSelectedRow(selectedRow + 1);
                }
                BrowserColorsOptionPane.this.updateEnabled();
            }
        }
    }

    class SelectionHandler
    implements ListSelectionListener {
        SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            BrowserColorsOptionPane.this.updateEnabled();
        }
    }
}

