/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.indent.IndentRule;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;

public abstract class BracketIndentRule
implements IndentRule {
    protected char openBracket;
    protected char closeBracket;

    public BracketIndentRule(char openBracket, char closeBracket) {
        this.openBracket = openBracket;
        this.closeBracket = closeBracket;
    }

    @Deprecated
    public Brackets getBrackets(String line) {
        Brackets brackets = new Brackets();
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (ch == this.openBracket) {
                if (line.length() - i >= 3 && line.substring(i, i + 3).equals("{{{")) {
                    i += 2;
                    continue;
                }
                ++brackets.openCount;
                continue;
            }
            if (ch != this.closeBracket) continue;
            if (brackets.openCount != 0) {
                --brackets.openCount;
                continue;
            }
            ++brackets.closeCount;
        }
        return brackets;
    }

    public Brackets getBrackets(JEditBuffer buffer, int lineIndex) {
        return this.getBrackets(buffer, lineIndex, 0, buffer.getLineLength(lineIndex));
    }

    public Brackets getBrackets(JEditBuffer buffer, int lineIndex, int begin, int end) {
        LineScanner scanner = new LineScanner(begin, end);
        buffer.markTokens(lineIndex, scanner);
        return scanner.result;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.openBracket + "," + this.closeBracket + "]";
    }

    private class LineScanner
    implements TokenHandler {
        public final Brackets result = new Brackets();
        private int scannedIndex = 0;
        private final int beginIndex;
        private final int endIndex;

        public LineScanner(int begin, int end) {
            this.beginIndex = begin;
            this.endIndex = end;
        }

        boolean rejectsToken(byte id) {
            switch (id) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    return true;
                }
            }
            return false;
        }

        private void scan(Segment seg, int offset, int length) {
            int index = this.scannedIndex;
            if (index >= this.endIndex) {
                return;
            }
            if (index < this.beginIndex) {
                int numToSkip = this.beginIndex - index;
                if (numToSkip >= length) {
                    return;
                }
                offset += numToSkip;
                length -= numToSkip;
                index = this.beginIndex;
            }
            if (index + length > this.endIndex) {
                length = this.endIndex - index;
            }
            for (int i = 0; i < length; ++i) {
                char c = seg.array[seg.offset + offset + i];
                if (c == BracketIndentRule.this.openBracket) {
                    ++this.result.openCount;
                    continue;
                }
                if (c != BracketIndentRule.this.closeBracket) continue;
                if (this.result.openCount != 0) {
                    --this.result.openCount;
                    continue;
                }
                ++this.result.closeCount;
            }
        }

        public void handleToken(Segment seg, byte id, int offset, int length, TokenMarker.LineContext context) {
            if (!this.rejectsToken(id)) {
                this.scan(seg, offset, length);
            }
            this.scannedIndex += length;
        }

        public void setLineContext(TokenMarker.LineContext lineContext) {
        }
    }

    public static class Brackets {
        int openCount;
        int closeCount;
    }
}

