/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class ErrorsWidgetFactory
implements StatusWidgetFactory {
    public Widget getWidget(View view) {
        ErrorWidget errorWidget = new ErrorWidget(view);
        return errorWidget;
    }

    private static class ErrorDialog
    extends EnhancedDialog {
        private JTextArea textArea;
        private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        private PrintStream printStream = new PrintStream(this.byteArrayOutputStream);
        private JButton removeThisError;
        private JButton removeAllErrors;
        private Object[] throwables = Log.throwables.toArray();
        private JComboBox combo;

        private ErrorDialog(Frame view) {
            super(view, "Errors", false);
            this.textArea = new JTextArea();
            this.textArea.setEditable(false);
            if (this.throwables.length != 0) {
                Throwable throwable = (Throwable)this.throwables[0];
                this.setThrowable(throwable);
            }
            this.combo = new JComboBox<Object>(this.throwables);
            this.combo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ErrorDialog.this.setThrowable((Throwable)ErrorDialog.this.combo.getSelectedItem());
                }
            });
            this.getContentPane().add((Component)this.combo, "North");
            this.getContentPane().add(new JScrollPane(this.textArea));
            Box buttons = new Box(0);
            buttons.add(Box.createGlue());
            this.removeThisError = new JButton(jEdit.getProperty("grab-key.remove"));
            buttons.add(this.removeThisError);
            buttons.add(Box.createHorizontalStrut(6));
            this.removeAllErrors = new JButton(jEdit.getProperty("common.clearAll"));
            buttons.add(this.removeAllErrors);
            MyActionListener actionListener = new MyActionListener();
            this.removeThisError.addActionListener(actionListener);
            this.removeAllErrors.addActionListener(actionListener);
            buttons.add(Box.createGlue());
            this.getContentPane().add((Component)buttons, "South");
            this.pack();
            GUIUtilities.loadGeometry(this, "status.errorWidget");
            this.setVisible(true);
        }

        private void setThrowable(Throwable throwable) {
            if (throwable == null) {
                this.textArea.setText(null);
            } else {
                throwable.printStackTrace(this.printStream);
                this.textArea.setText(this.byteArrayOutputStream.toString());
                this.textArea.setCaretPosition(0);
                this.byteArrayOutputStream.reset();
            }
        }

        public void dispose() {
            GUIUtilities.saveGeometry(this, "status.errorWidget");
            super.dispose();
        }

        public void ok() {
            this.dispose();
        }

        public void cancel() {
            this.dispose();
        }

        private class MyActionListener
        implements ActionListener {
            private MyActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == ErrorDialog.this.removeThisError) {
                    Throwable throwable = (Throwable)ErrorDialog.this.combo.getSelectedItem();
                    if (throwable != null) {
                        Log.throwables.remove(throwable);
                        ErrorDialog.this.combo.removeItem(throwable);
                        if (ErrorDialog.this.combo.getItemCount() == 0) {
                            ErrorDialog.this.dispose();
                        }
                    }
                } else if (source == ErrorDialog.this.removeAllErrors) {
                    for (Object throwable : ErrorDialog.this.throwables) {
                        Log.throwables.remove(throwable);
                    }
                    ErrorDialog.this.dispose();
                }
            }
        }
    }

    private static class ErrorHighlight
    extends JLabel
    implements ActionListener {
        private int currentSize;
        private Timer timer;

        ErrorHighlight(final View view) {
            this.setForeground(jEdit.getColorProperty("view.status.foreground"));
            this.setBackground(jEdit.getColorProperty("view.status.background"));
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && !Log.throwables.isEmpty()) {
                        new ErrorDialog((Frame)view);
                    }
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.update();
            int millisecondsPerMinute = 1000;
            this.timer = new Timer(millisecondsPerMinute, this);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        public Point getToolTipLocation(MouseEvent event) {
            return new Point(event.getX(), -20);
        }

        public void actionPerformed(ActionEvent e) {
            this.update();
        }

        private void update() {
            int size = Log.throwables.size();
            if (size != this.currentSize) {
                this.currentSize = size;
                if (size == 0) {
                    this.setForeground(jEdit.getColorProperty("view.status.foreground"));
                    this.setText(null);
                    this.setToolTipText(size + " error");
                } else {
                    this.setForeground(Color.red);
                    this.setText(Integer.toString(size) + " error(s)");
                    this.setToolTipText(size + " error(s)");
                }
            }
        }
    }

    private static class ErrorWidget
    implements Widget {
        private final ErrorHighlight errorHighlight;

        ErrorWidget(View view) {
            this.errorHighlight = new ErrorHighlight(view);
        }

        public JComponent getComponent() {
            return this.errorHighlight;
        }

        public void update() {
            this.errorHighlight.update();
        }

        public void propertiesChanged() {
        }
    }
}

