/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;

public class RolloverButton
extends JButton {
    private static final AlphaComposite c = AlphaComposite.getInstance(3, 0.5f);
    private boolean revalidateBlocked;

    public RolloverButton() {
        this.addMouseListener(new MouseOverHandler());
    }

    public RolloverButton(Icon icon) {
        this();
        this.setIcon(icon);
    }

    public void updateUI() {
        super.updateUI();
        this.setBorderPainted(false);
        this.setRequestFocusEnabled(false);
        this.setMargin(new Insets(1, 1, 1, 1));
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setBorderPainted(false);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBorderPainted(boolean b) {
        try {
            this.revalidateBlocked = true;
            super.setBorderPainted(b);
            this.setContentAreaFilled(b);
        }
        finally {
            this.revalidateBlocked = false;
        }
    }

    public void revalidate() {
        if (!this.revalidateBlocked) {
            super.revalidate();
        }
    }

    public void paint(Graphics g) {
        if (this.isEnabled()) {
            super.paint(g);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(c);
            super.paint(g2);
        }
    }

    class MouseOverHandler
    extends MouseAdapter {
        MouseOverHandler() {
        }

        public void mouseEntered(MouseEvent e) {
            RolloverButton.this.setContentAreaFilled(true);
            RolloverButton.this.setBorderPainted(RolloverButton.this.isEnabled());
        }

        public void mouseExited(MouseEvent e) {
            RolloverButton.this.setContentAreaFilled(false);
            RolloverButton.this.setBorderPainted(false);
        }
    }
}

