/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputHandler
extends AbstractInputHandler<EditAction> {
    protected final View view;

    protected InputHandler(View view) {
        this.view = view;
    }

    public final boolean handleKey(KeyEventTranslator.Key keyStroke) {
        return this.handleKey(keyStroke, false);
    }

    @Override
    public void processKeyEvent(KeyEvent evt, int from, boolean global) {
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event                 : " + AbstractInputHandler.toString(evt) + " from " + from);
            Log.log(1, this, this.view + ".isFocused()=" + this.view.isFocused() + '.', new Exception());
        }
        if (this.view.getTextArea().hasFocus() && from == 0) {
            return;
        }
        if ((evt = this._preprocessKeyEvent(evt)) == null) {
            return;
        }
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event after workaround: " + AbstractInputHandler.toString(evt) + " from " + from);
        }
        Component prefixFocusOwner = this.view.getPrefixFocusOwner();
        boolean focusOnTextArea = false;
        switch (evt.getID()) {
            case 400: {
                if (prefixFocusOwner != null && prefixFocusOwner.isShowing()) {
                    prefixFocusOwner.requestFocus();
                    focusOnTextArea = true;
                }
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyTyped(evt);
                } else if (from == 2 || this.isPrefixActive() || this.view.getTextArea().hasFocus()) {
                    this.processKeyEventKeyStrokeHandling(evt, from, "type ", global);
                }
                this.processKeyEventSub(focusOnTextArea);
                break;
            }
            case 401: {
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyPressed(evt);
                    break;
                }
                if (!KeyEventWorkaround.isBindable(evt.getKeyCode())) break;
                if (prefixFocusOwner != null) {
                    if (prefixFocusOwner.isShowing()) {
                        prefixFocusOwner.requestFocus();
                        focusOnTextArea = true;
                    }
                    this.view.setPrefixFocusOwner(null);
                }
                this.processKeyEventKeyStrokeHandling(evt, from, "press", global);
                this.processKeyEventSub(focusOnTextArea);
                break;
            }
            case 402: {
                if (this.keyEventInterceptor == null) break;
                this.keyEventInterceptor.keyReleased(evt);
            }
        }
    }

    private KeyEvent _preprocessKeyEvent(KeyEvent evt) {
        if (this.view.isClosed()) {
            return null;
        }
        Component focusOwner = this.view.getFocusOwner();
        if (focusOwner instanceof JComponent) {
            KeyStroke keyStroke;
            Object binding;
            JComponent comp = (JComponent)focusOwner;
            InputMap map = comp.getInputMap();
            ActionMap am = comp.getActionMap();
            if (map != null && am != null && comp.isEnabled() && (binding = map.get(keyStroke = KeyStroke.getKeyStrokeForEvent(evt))) != null && am.get(binding) != null) {
                return null;
            }
        }
        if (focusOwner instanceof JTextComponent && evt.getID() == 401) {
            switch (evt.getKeyCode()) {
                case 8: 
                case 9: 
                case 10: 
                case 32: {
                    return null;
                }
            }
        }
        if (evt.isConsumed()) {
            return null;
        }
        if (Debug.DUMP_KEY_EVENTS) {
            Log.log(1, this, "Key event (preprocessing) : " + AbstractInputHandler.toString(evt));
        }
        return KeyEventWorkaround.processKeyEvent(evt);
    }

    private void processKeyEventSub(boolean focusOnTextArea) {
        if (this.view.isClosed()) {
            return;
        }
        if (this.isPrefixActive()) {
            Component focusOwner = this.view.getFocusOwner();
            if (focusOwner instanceof JTextComponent) {
                this.view.setPrefixFocusOwner(focusOwner);
                this.view.getTextArea().requestFocus();
            } else if (focusOnTextArea) {
                this.view.getTextArea().requestFocus();
            } else {
                this.view.setPrefixFocusOwner(null);
            }
        } else {
            this.view.setPrefixFocusOwner(null);
        }
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        int oldRepeatCount = this.repeatCount;
        this.repeatCount = repeatCount;
        if (oldRepeatCount != repeatCount) {
            this.view.getStatus().setMessage(null);
        }
    }

    public EditAction getLastAction() {
        return (EditAction)this.lastAction;
    }

    public void readNextChar(String msg, String code) {
        this.view.getStatus().setMessage(msg);
        this.readNextChar = code;
    }

    @Deprecated
    public void readNextChar(String code) {
        this.readNextChar = code;
    }

    @Override
    public void invokeAction(String action) {
        this.invokeAction(jEdit.getAction(action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAction(EditAction action) {
        Buffer buffer = this.view.getBuffer();
        if (!action.noRememberLast()) {
            HistoryModel.getModel("action").addItem(action.getName());
            if (this.lastAction == action) {
                ++this.lastActionCount;
            } else {
                this.lastAction = action;
                this.lastActionCount = 1;
            }
        }
        int _repeatCount = this.repeatCount;
        if (action.noRepeat() || _repeatCount == 1) {
            action.invoke(this.view);
        } else {
            String label;
            Object[] pp;
            if (_repeatCount > 20 && GUIUtilities.confirm(this.view, "large-repeat-count", pp = new Object[]{label = (label = action.getLabel()) == null ? action.getName() : GUIUtilities.prettifyMenuLabel(label), _repeatCount}, 2, 0) != 0) {
                this.repeatCount = 1;
                this.view.getStatus().setMessage(null);
                return;
            }
            try {
                buffer.beginCompoundEdit();
                for (int i = 0; i < _repeatCount; ++i) {
                    action.invoke(this.view);
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null && !action.noRecord()) {
            recorder.record(_repeatCount, action.getCode());
        }
        if (_repeatCount != 1) {
            if (this.readNextChar != null) {
                return;
            }
            this.repeatCount = 1;
            this.view.getStatus().setMessage(null);
        }
    }

    public void invokeLastAction() {
        if (this.lastAction == null) {
            this.view.getToolkit().beep();
        } else {
            this.invokeAction((EditAction)this.lastAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void userInput(char ch) {
        this.lastActionCount = 0;
        JEditTextArea textArea = this.view.getTextArea();
        if (this.repeatCount == 1) {
            textArea.userInput(ch);
        } else {
            Object[] pp;
            if (this.repeatCount > 20 && GUIUtilities.confirm(this.view, "large-repeat-count.user-input", pp = new Object[]{String.valueOf(ch), this.repeatCount}, 2, 0) != 0) {
                this.repeatCount = 1;
                this.view.getStatus().setMessage(null);
                return;
            }
            Buffer buffer = this.view.getBuffer();
            try {
                if (this.repeatCount != 1) {
                    buffer.beginCompoundEdit();
                }
                for (int i = 0; i < this.repeatCount; ++i) {
                    textArea.userInput(ch);
                }
            }
            finally {
                if (this.repeatCount != 1) {
                    buffer.endCompoundEdit();
                }
            }
        }
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null) {
            recorder.recordInput(this.repeatCount, ch, textArea.isOverwriteEnabled());
        }
        this.repeatCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeReadNextChar(char ch) {
        int index;
        Buffer buffer = this.view.getBuffer();
        String charStr = StandardUtilities.charsToEscapes(String.valueOf(ch));
        while ((index = this.readNextChar.indexOf("__char__")) != -1) {
            this.readNextChar = this.readNextChar.substring(0, index) + '\'' + charStr + '\'' + this.readNextChar.substring(index + 8);
        }
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null) {
            recorder.record(this.getRepeatCount(), this.readNextChar);
        }
        this.view.getStatus().setMessage(null);
        if (this.getRepeatCount() != 1) {
            try {
                buffer.beginCompoundEdit();
                BeanShell.eval(this.view, BeanShell.getNameSpace(), "for(int i = 1; i < " + this.getRepeatCount() + "; i++)\n{\n" + this.readNextChar + "\n}");
            }
            finally {
                buffer.endCompoundEdit();
            }
        } else {
            BeanShell.eval(this.view, BeanShell.getNameSpace(), this.readNextChar);
        }
        this.readNextChar = null;
    }
}

