/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferset;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetAdapter;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;

public class BufferSetManager
implements EBComponent {
    private final BufferSet global = new BufferSet(BufferSet.Scope.global);
    private final Map<View, BufferSet> viewBufferSetMap = Collections.synchronizedMap(new HashMap());
    private final Map<EditPane, BufferSet> editPaneBufferSetMap = Collections.synchronizedMap(new HashMap());
    private final Map<Buffer, Set<BufferSet>> bufferBufferSetMap = Collections.synchronizedMap(new HashMap());

    public BufferSetManager() {
        EditBus.addToBus(this);
    }

    public void handleMessage(EBMessage message) {
        EditPane editPane;
        BufferSet editPaneBufferSet;
        EditPaneUpdate editPaneUpdate;
        if (message instanceof ViewUpdate) {
            View view;
            BufferSet viewBufferSet;
            ViewUpdate viewUpdate = (ViewUpdate)message;
            if (viewUpdate.getWhat() == ViewUpdate.CLOSED && (viewBufferSet = this.viewBufferSetMap.remove(view = viewUpdate.getView())) != null) {
                viewBufferSet.getAllBuffers(new BufferSetClosed(viewBufferSet));
            }
        } else if (message instanceof EditPaneUpdate && (editPaneUpdate = (EditPaneUpdate)message).getWhat() == EditPaneUpdate.DESTROYED && (editPaneBufferSet = this.editPaneBufferSetMap.remove(editPane = editPaneUpdate.getEditPane())) != null) {
            editPaneBufferSet.getAllBuffers(new BufferSetClosed(editPaneBufferSet));
        }
    }

    public BufferSet getGlobalBufferSet() {
        return this.global;
    }

    public BufferSet getViewBufferSet(View view) {
        BufferSet bufferSet = this.viewBufferSetMap.get(view);
        if (bufferSet == null) {
            bufferSet = new BufferSet(BufferSet.Scope.view);
            this.viewBufferSetMap.put(view, bufferSet);
        }
        return bufferSet;
    }

    public BufferSet getEditPaneBufferSet(EditPane editPane) {
        BufferSet bufferSet = this.editPaneBufferSetMap.get(editPane);
        if (bufferSet == null) {
            bufferSet = new BufferSet(BufferSet.Scope.editpane);
            this.editPaneBufferSetMap.put(editPane, bufferSet);
        }
        return bufferSet;
    }

    public void mergeBufferSet(BufferSet target, BufferSet source) {
        Buffer[] buffers;
        for (Buffer buffer : buffers = source.getAllBuffers()) {
            this.addBuffer(target, buffer);
        }
    }

    public int countBufferSets(Buffer buffer) {
        Set<BufferSet> sets = this.bufferBufferSetMap.get(buffer);
        if (sets == null) {
            return 0;
        }
        return sets.size();
    }

    public void addBuffer(View view, Buffer buffer) {
        EditPane editPane = view == null ? null : view.getEditPane();
        this.addBuffer(editPane, buffer);
    }

    public void addBuffer(EditPane editPane, Buffer buffer) {
        if (editPane == null) {
            this.addBuffer(this.global, buffer);
        } else {
            BufferSet bufferSet = editPane.getBufferSet();
            this.addBuffer(bufferSet, buffer);
        }
    }

    public void addBuffer(BufferSet bufferSet, Buffer buffer) {
        Set<BufferSet> bufferSets = this.bufferBufferSetMap.get(buffer);
        if (bufferSets == null) {
            bufferSets = new HashSet<BufferSet>();
            this.bufferBufferSetMap.put(buffer, bufferSets);
        }
        bufferSets.add(bufferSet);
        bufferSet.addBuffer(buffer);
    }

    public void addAllBuffers(BufferSet bufferSet) {
        Buffer[] buffers;
        for (Buffer buffer : buffers = jEdit.getBuffers()) {
            if (buffer.isClosed()) continue;
            this.addBuffer(bufferSet, buffer);
        }
    }

    public void removeBuffer(EditPane editPane, Buffer buffer) {
        BufferSet bufferSet = editPane.getBufferSet();
        this.removeBuffer(bufferSet, buffer);
    }

    void removeBuffer(BufferSet bufferSet, Buffer buffer) {
        Log.log(1, this, "removeBuffer(" + bufferSet + ',' + buffer + ')');
        Set<BufferSet> bufferSets = this.bufferBufferSetMap.get(buffer);
        bufferSets.remove(bufferSet);
        bufferSet.removeBuffer(buffer);
        if (bufferSets.isEmpty()) {
            Log.log(1, this, "Buffer:" + buffer + " is in no bufferSet anymore, closing it");
            jEdit._closeBuffer(null, buffer);
        } else if (!this.hasListeners(buffer)) {
            Log.log(1, this, "Buffer:" + buffer + " is only in bufferSets that have no listeners, closing it");
            jEdit._closeBuffer(null, buffer);
        }
        if (bufferSet.size() == 0 && bufferSet.hasListeners()) {
            int untitledCount = jEdit.getNextUntitledBufferId();
            Buffer newEmptyBuffer = jEdit.openTemporary(jEdit.getActiveView(), null, "Untitled-" + untitledCount, true, null);
            jEdit.commitTemporary(newEmptyBuffer);
            jEdit.getBufferSetManager().addBuffer(bufferSet, newEmptyBuffer);
        }
    }

    public boolean hasListeners(Buffer buffer) {
        Set<BufferSet> bufferSets = this.bufferBufferSetMap.get(buffer);
        if (bufferSets == null) {
            return false;
        }
        for (BufferSet bs : bufferSets) {
            if (!bs.hasListeners()) continue;
            return true;
        }
        return false;
    }

    public void removeBuffer(Buffer buffer) {
        Set<BufferSet> sets = this.bufferBufferSetMap.remove(buffer);
        for (BufferSet bufferSet : sets) {
            bufferSet.removeBuffer(buffer);
            if (bufferSet.size() != 0 || !bufferSet.hasListeners()) continue;
            int untitledCount = jEdit.getNextUntitledBufferId();
            Buffer newEmptyBuffer = jEdit.openTemporary(jEdit.getActiveView(), null, "Untitled-" + untitledCount, true, null);
            jEdit.commitTemporary(newEmptyBuffer);
            jEdit.getBufferSetManager().addBuffer(bufferSet, newEmptyBuffer);
        }
    }

    public void clear() {
        this.bufferBufferSetMap.clear();
        this.visit(new BufferSetVisitor(){

            public void visit(BufferSet bufferSet) {
                bufferSet.clear();
            }
        });
    }

    public void visit(BufferSetVisitor visitor) {
        visitor.visit(this.global);
        Collection<BufferSet> bufferSetCollection = this.viewBufferSetMap.values();
        for (BufferSet bufferSet : bufferSetCollection) {
            visitor.visit(bufferSet);
        }
        Collection<BufferSet> sets = this.editPaneBufferSetMap.values();
        for (BufferSet bufferSet : sets) {
            visitor.visit(bufferSet);
        }
    }

    private class BufferSetClosed
    extends BufferSetAdapter {
        private BufferSet closedBufferSet;

        private BufferSetClosed(BufferSet closedBufferSet) {
            this.closedBufferSet = closedBufferSet;
        }

        public void bufferAdded(Buffer buffer, int index) {
            Set sets = (Set)BufferSetManager.this.bufferBufferSetMap.get(buffer);
            sets.remove(this.closedBufferSet);
            if (sets.isEmpty()) {
                if (buffer.isDirty()) {
                    EditPane editPane = jEdit.getActiveView().getEditPane();
                    Log.log(3, this, "The buffer " + buffer + " was removed from a BufferSet, it is dirty, adding it to " + editPane);
                    editPane.setBuffer(buffer);
                } else {
                    Log.log(3, this, "The buffer " + buffer + " was removed from a BufferSet, it is clean, closing it");
                    jEdit._closeBuffer(null, buffer);
                }
            }
        }
    }

    public static interface BufferSetVisitor {
        public void visit(BufferSet var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NewBufferSetAction {
        empty,
        copy,
        currentbuffer;


        public static NewBufferSetAction fromString(String s) {
            NewBufferSetAction[] newBufferSetActions;
            for (NewBufferSetAction newBufferSetAction : newBufferSetActions = NewBufferSetAction.values()) {
                if (!newBufferSetAction.toString().equals(s)) continue;
                return newBufferSetAction;
            }
            return currentbuffer;
        }

        public String toString() {
            return jEdit.getProperty("options.editpane.bufferset.newbufferset." + super.toString());
        }
    }
}

