/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class ServiceListHandler
extends DefaultHandler {
    private PluginJAR plugin;
    private URL uri;
    private String serviceName;
    private String serviceClass;
    private StringBuffer code;
    private Stack stateStack;
    private List cachedServices;

    ServiceListHandler(PluginJAR plugin, URL uri) {
        this.plugin = plugin;
        this.uri = uri;
        this.code = new StringBuffer();
        this.stateStack = new Stack();
        this.cachedServices = new LinkedList();
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return XMLUtilities.findEntity(systemId, "services.dtd", this.getClass());
    }

    public void characters(char[] c, int off, int len) {
        String tag = this.peekElement();
        if (tag == "SERVICE") {
            this.code.append(c, off, len);
        }
    }

    public void startElement(String uri, String localName, String tag, Attributes attrs) {
        tag = this.pushElement(tag);
        this.serviceName = attrs.getValue("NAME");
        this.serviceClass = attrs.getValue("CLASS");
    }

    public void endElement(String uri, String localName, String name) {
        String tag = this.peekElement();
        if (name.equals(tag)) {
            if (tag.equals("SERVICE")) {
                ServiceManager.Descriptor d = new ServiceManager.Descriptor(this.serviceClass, this.serviceName, this.code.toString(), this.plugin);
                ServiceManager.registerService(d);
                this.cachedServices.add(d);
                this.code.setLength(0);
            }
        } else {
            throw new InternalError();
        }
        this.popElement();
    }

    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ServiceManager.Descriptor[] getCachedServices() {
        return this.cachedServices.toArray(new ServiceManager.Descriptor[this.cachedServices.size()]);
    }

    private String pushElement(String name) {
        name = name == null ? null : name.intern();
        this.stateStack.push(name);
        return name;
    }

    private String peekElement() {
        return (String)this.stateStack.peek();
    }

    private String popElement() {
        return (String)this.stateStack.pop();
    }
}

