/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import org.gjt.sp.jedit.RegisterSaver;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.SettingsXML;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class JEditRegisterSaver
implements RegisterSaver {
    private SettingsXML registersXML;

    JEditRegisterSaver() {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory != null) {
            this.registersXML = new SettingsXML(settingsDirectory, "registers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadRegisters() {
        if (this.registersXML == null) {
            return;
        }
        if (!this.registersXML.fileExists()) {
            return;
        }
        Log.log(3, jEdit.class, "Loading " + this.registersXML);
        RegistersHandler handler = new RegistersHandler();
        try {
            try {
                Registers.setLoading(true);
                this.registersXML.load(handler);
            }
            catch (IOException ioe) {
                Log.log(9, Registers.class, ioe);
                Object var4_3 = null;
                Registers.setLoading(false);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Registers.setLoading(false);
            throw throwable;
        }
        Registers.setLoading(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveRegisters() {
        if (this.registersXML == null) {
            return;
        }
        if (this.registersXML.hasChangedOnDisk()) {
            Log.log(7, Registers.class, this.registersXML + " changed on disk; will not save registers");
            return;
        }
        Log.log(3, Registers.class, "Saving " + this.registersXML);
        String lineSep = System.getProperty("line.separator");
        SettingsXML.Saver out = null;
        try {
            try {
                out = this.registersXML.openSaver();
                out.writeXMLDeclaration();
                out.write("<!DOCTYPE REGISTERS SYSTEM \"registers.dtd\">");
                out.write(lineSep);
                out.write("<REGISTERS>");
                out.write(lineSep);
                Registers.Register[] registers = Registers.getRegisters();
                for (int i = 0; i < registers.length; ++i) {
                    Registers.Register register = registers[i];
                    if (register == null || i == 36 || i == 37 || ((Object)register).toString().length() == 0) continue;
                    out.write("<REGISTER NAME=\"");
                    if (i == 34) {
                        out.write("&quot;");
                    } else {
                        out.write((char)i);
                    }
                    out.write("\">");
                    out.write(XMLUtilities.charsToEntities(((Object)register).toString(), false));
                    out.write("</REGISTER>");
                    out.write(lineSep);
                }
                out.write("</REGISTERS>");
                out.write(lineSep);
                out.finish();
            }
            catch (Exception e) {
                Log.log(9, Registers.class, e);
                Object var7_8 = null;
                IOUtilities.closeQuietly(out);
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            IOUtilities.closeQuietly(out);
            throw throwable;
        }
        IOUtilities.closeQuietly(out);
    }

    private static class RegistersHandler
    extends DefaultHandler {
        private String registerName;
        private final StringBuilder charData = new StringBuilder();
        private boolean inRegister;

        private RegistersHandler() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            return XMLUtilities.findEntity(systemId, "registers.dtd", this.getClass());
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            this.registerName = attrs.getValue("NAME");
            this.inRegister = "REGISTER".equals(qName);
        }

        public void endElement(String uri, String localName, String name) {
            if ("REGISTER".equals(name)) {
                if (this.registerName == null || this.registerName.length() != 1) {
                    Log.log(9, this, "Malformed NAME: " + this.registerName);
                } else {
                    Registers.setRegister(this.registerName.charAt(0), this.charData.toString());
                }
                this.inRegister = false;
                this.charData.setLength(0);
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.inRegister) {
                this.charData.append(ch, start, length);
            }
        }
    }
}

