/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gjt.sp.jedit.SettingsXML;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class JEditKillRing
extends KillRing {
    private SettingsXML killringXML;

    public JEditKillRing() {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory != null) {
            this.killringXML = new SettingsXML(settingsDirectory, "killring");
        }
    }

    public void load() {
        if (this.killringXML == null) {
            return;
        }
        if (!this.killringXML.fileExists()) {
            return;
        }
        Log.log(3, KillRing.class, "Loading " + this.killringXML);
        KillRingHandler handler = new KillRingHandler();
        try {
            this.killringXML.load(handler);
        }
        catch (IOException ioe) {
            Log.log(9, this, ioe);
        }
        this.reset(handler.list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() {
        if (this.killringXML == null) {
            return;
        }
        if (this.killringXML.hasChangedOnDisk()) {
            Log.log(7, KillRing.class, this.killringXML + " changed on disk; will not save killring" + " files");
            return;
        }
        Log.log(3, KillRing.class, "Saving " + this.killringXML);
        String lineSep = System.getProperty("line.separator");
        SettingsXML.Saver out = null;
        try {
            try {
                out = this.killringXML.openSaver();
                out.writeXMLDeclaration("1.1");
                out.write("<!DOCTYPE KILLRING SYSTEM \"killring.dtd\">");
                out.write(lineSep);
                out.write("<KILLRING>");
                out.write(lineSep);
                int size = this.getSize();
                for (int i = size - 1; i >= 0; --i) {
                    out.write("<ENTRY>");
                    out.write(XMLUtilities.charsToEntities(this.getElementAt(i).toString(), true));
                    out.write("</ENTRY>");
                    out.write(lineSep);
                }
                out.write("</KILLRING>");
                out.write(lineSep);
                out.finish();
            }
            catch (Exception e) {
                Log.log(9, KillRing.class, e);
                Object var6_7 = null;
                IOUtilities.closeQuietly(out);
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            IOUtilities.closeQuietly(out);
            throw throwable;
        }
        IOUtilities.closeQuietly(out);
    }

    private static class KillRingHandler
    extends DefaultHandler {
        public List<String> list = new LinkedList<String>();
        private StringBuffer charData = new StringBuffer();
        private boolean inEntry;

        private KillRingHandler() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            return XMLUtilities.findEntity(systemId, "killring.dtd", this.getClass());
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            this.inEntry = qName.equals("ENTRY");
        }

        public void endElement(String uri, String localName, String name) {
            if (name.equals("ENTRY")) {
                this.list.add(this.charData.toString());
                this.inEntry = false;
                this.charData.setLength(0);
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.inEntry) {
                this.charData.append(ch, start, length);
            }
        }
    }
}

