#!/usr/bin/python
# -*- coding: UTF-8 -*-

def dict_as_stop(dct):
	"""
	Turns the values of a dictionary into a Stop.
	"""
	stop = Stop()
	stop.id = int(dct['id'])
	stop.name = dct['name']
	stop.northing = dct['northing']
	stop.easting = dct['easting']
	stop.latitude = dct['latitude']
	stop.longitude = dct['longitude']
	stop.distance = dct['distance']
	return stop

class Stop:
	id = None
	name = None
	northing = None
	easting = None
	latitude = None
	longitude = None
	distance = None
	
	def save_to_db(self, db):
		"""
		Saves the currect Stop to the database provided.
		"""
		cursor = db.cursor()
		params = (self.id, self.name, self.northing, self.easting, self.latitude, self.longitude,)
		cursor.execute('insert into stops values (?, ?, ?, ?, ?, ?)', params)
		db.commit()
		cursor.close()
	
	def set_from_db_row(self, row):
		"""
		Takes a row from a database and extracts it's values to the current Stop.
		"""
		self.id = row[0]
		self.name = row[1]
		self.northing = row[2]
		self.easting = row[3]
		self.latitude = row[4]
		self.longitude = row[5]
		return self
