#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import location, time, pickle, math, webbrowser, sqlite3, urllib
import simplejson as json
from gpscollector import Collector
from models import Stop, dict_as_stop


def get_fix():
	# Get GPS fix.
	print 'Getting GPS fix...'
	col = Collector()
	col.run()
	la, lo = col.data[len(col.data)-1][4:6]
	print 'Got fix: [%f,%f].' % (la, lo,)
	return la, lo

def get_stops(la, lo):
	# Retrieve nearest stops from web.
	print 'Getting nearest stops from internet...'
	url = urllib.urlopen('http://rejseplanen.cannedtuna.org/json.php?la=%f&lo=%f' % (la, lo,))
	data = ''
	for line in url:
		data += line
	nearest = json.loads(data, object_hook=dict_as_stop)
	print 'Got %i stops.' % len(nearest)
	return nearest

def select_stop(nearest):
	# Show stop menu.
	print '\n\n***** Pick a stop: *****'
	for i in range(0, len(nearest)):
		stop = nearest[i]
		dist = str(round(stop.distance, 2)) + 'km'
		if stop.distance < 1:
			dist = str(int(stop.distance * 1000)) + 'm'
		print ('%i' % (i+1)).ljust(5), stop.name, '(' + dist + ')'

	# Get proper user input.
	choice = 'a'
	while not type(choice) is int:
		try:
			choice = int(raw_input('Stop no.: '))
		except ValueError:
			choice = 'a'
		if choice < 1 or choice > len(nearest):
			choice = 'a'
	return choice

def open_browser(stop):
	# Launch time table for stop in browser.
	print 'Opening time tables for %s...' % stop.name
	webbrowser.open('http://www.rejseplanen.dk/bin/stboard.exe/mn?ml=m&input=%i&boardType=dep&time=now&start=yes' % stop.id)

# Run as a terminal script if run directly. Use gui.py if you want a nice GUI for all this.
if __name__ == '__main__':
	la, lo = get_fix()
	nearest = get_stops(la, lo)
	choice = select_stop(nearest)
	stop = nearest[choice - 1]
	open_browser(stop)
