#!/bin/bash

pwd=$(pwd)

export PS1='\w\$ '
umask 022
version="03"


echo "--------------------------------------------------------------"
echo "Setting PATH to $pwd:$PATH"
export PATH=$pwd:$PATH




if [ ! -d data ]
then
 echo "--------------------------------------------------------------"
 echo "mkdir data"
 mkdir data
fi

BIOS=1
if [ ! -e data/dc_bios.bin ];then
	BIOS=0
fi
if [ ! -e data/dc_flash.bin ];then
	BIOS=0
fi

if [ $BIOS -eq 0 ];then
 zenity --error --title "REICAST" --text "You need BIOS files from a Dreamcast system.
Files must be named <span color=\"red\">dc_bios.bin</span> and <span color=\"red\">dc_flash.bin</span>
and should be puted in the <span color=\"blue\">appdata/reicast/data</span> folder."
exit
fi

if [ ! 

#zenity dialog to choose a disc
if [ -z "$@" ];then
	OLDSELECT=""
	if [ -e home/.oldfile ];then
	 CDFILE=`cat home/.oldfile`
	 OLDSELECT="--filename=\"$CDFILE\""
	fi

	cd $(dirname ${CDFILE})
	CDFILE=`zenity --file-selection $OLDSELECT --file-filter="*.cdi" --file-filter="*.gdi" --file-filter="*.iso"`
	case $? in
			 0)
					echo "$CDFILE" selected.
					echo "$CDFILE">home/.oldfile;;
			 1)
					echo "No file selected.";;
			-1)
					echo "No file selected.";;
	esac
	cd $OLDPWD
else
	CDFILE="$@"
fi


echo ./reicast.elf -config config:image=$CDFILE

