/* vim: set ts=4 sw=4 et: */
/*
 * maemo-recorder.h
 *
 * Copyright (C) 2006 Nokia Corporation
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef _MAEMO_RECORDER_H_
#define _MAEMO_RECORDER_H_

#include <libosso.h>
#include <osso-log.h>
#include <hildon/hildon-program.h>
#include <hildon/hildon-window.h>
#include <gconf/gconf-client.h>

#include <gtk/gtk.h>
#include <gst/gst.h>
#include <sys/time.h>

#define SERVICE_NAME "maemo_recorder"
#define SERVICE_NAME_FULL "com.nokia.maemo_recorder"

#define DEFAULT_CHANNELS 1
#define DEFAULT_RATE 22050

#define GST_TYPE_ILBC "audio/x-iLBC"
#define ILBC_RATE DEFAULT_RATE

/* 
 * 15.2 kbps (SI kilo) for 20 ms frames
 * 38 bytes / frame, 50 frames / sec 
 */
/* 13.33 kbps for 30 ms frames */
#define ILBC_BITRATE_20 15200
#define ILBC_BITRATE_30 13300

/* 8000 Hz * 8 bits/sample */
#define PCMA_BITRATE 64000
#define PCMU_BITRATE 64000

#define GST_TYPE_PCMA "audio/x-alaw"
#define GST_TYPE_PCMU "audio/x-mulaw"
#define GST_TYPE_PCM "audio/x-raw-int"
#define PCM_RATE 22050
#define PCM_WIDTH 16
#define PCM_DEPTH 16
#define PCM_ENDIANNESS 1234

typedef enum
{
    APPSTATE_READY = 1,
    APPSTATE_PLAYING,
    APPSTATE_RECORDING,
    APPSTATE_PAUSED
} AppState;

typedef enum
{
    FORMAT_NONE = 0,
    FORMAT_PCM,
    FORMAT_PCMA,
    FORMAT_PCMU,
    FORMAT_ILBC,
    FORMAT_MP3,
    FORMAT_WAV
} AudioFormat;

#define FORMAT_NAME_WAV "WAV"
#define FORMAT_NAME_PCMA "PCM A-law"
#define FORMAT_NAME_PCMU "PCM \u03BC-law"
/*
#define FORMAT_NAME_PCMU "PCM mu-law"
*/
#define FORMAT_NAME_PCM "PCM raw"
#define FORMAT_NAME_ILBC "iLBC"

#define PLAY_ICON "/usr/share/pixmaps/recorder/play.png"
#define REC_ICON "/usr/share/pixmaps/recorder/record.png"
#define STOP_ICON "/usr/share/pixmaps/recorder/stop.png"

#define DEFAULT_TMP_DIR "/home/user/MyDocs/.recorder"

/* TODO: this kind of struct might be more handy when passing around audioformat info */
#if 0
struct _AudioFormatSpec
{
    AudioFormat format;
    gchar *mime_type;
    gint rate;
    gint channels;
    gint width;
    gint depth;
    gint endianness;
    gint frame_len;
    gint frame_size;
};

typedef struct _AudioFormatSpec AudioFormatSpec;
#endif

typedef enum
{
    TYPE_FILE = 0,
    TYPE_STREAM = 1
} PipeMode;

typedef struct _mainViewStr
{
    GtkWidget *toolBar;
    GtkWidget *fileNameEntry;
    GtkWidget *lengthEntry;
    GtkWidget *stateEntry;
    GtkWidget *formatEntry;
    GtkObject *adjustment;
    GtkWidget *ctime;
} mainViewStr;

typedef struct _AppDataStr
{
    HildonProgram *app;
    HildonWindow *mainView;

    mainViewStr mainViewData;

    /* gstreamer components */
    GstElement *pipeline;
    GstElement *recPipeline;
    GstElement *playPipeline;
    GstElement *queue;
    gint playPipelineType;

    osso_context_t *osso;
    GConfClient *gconf_client;

    gchar * openFileName;
    gchar * saveFileName;
    gboolean saved;

    AudioFormat filter;      /* selected recording format */
    AudioFormat file_format; /* format of the recorded file or file currently open */
    PipeMode type;
    GtkWidget* radio_pcma;
    GtkWidget* radio_ilbc;
    GtkWidget* radio_pcm;          
    GtkWidget* radiotype;
    AppState state;

    GtkWidget *buttonSave;
    GtkWidget *buttonSaveAs;
    GtkWidget *buttonPlay;
    GtkWidget *buttonRec;

    guint recUpdateId;     /* g_source_id for rec update timeout func */
    gchar *mimeURI;        /* uri to open via mime cb */
    gdouble rectime;
} AppData;

void setAppState(AppData *app, AppState state);
AppState getAppState(AppData *app);

#if 0
AudioFormatSpec * audio_format_spec_new(void);
void audio_format_spec_free(AudioFormatSpec *af);
#endif

#endif /* _MAEMO_RECORDER_H_ */
