/* vim: set ts=4 sw=4 et: */
/*
 * maemo-recorder-file.h
 * File-related operations
 *
 * Copyright (C) 2006 Nokia Corporation
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef MAEMO_RECORDER_FILE_H_
#define MAEMO_RECORDER_FILE_H_

#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

G_BEGIN_DECLS

#define EXTENSION_ILBC ".ilbc"
#define EXTENSION_RAW ".raw"
#define EXTENSION_PCMA ".pcma"
#define EXTENSION_PCMU ".pcmu"
#define EXTENSION_MP3 ".mp3"
#define EXTENSION_AU ".au"
#define EXTENSION_SND ".snd"
#define EXTENSION_WAV ".wav"

#define DEFAULT_TMP_PCMA_FILE "mrec.pcma"
#define DEFAULT_TMP_PCMU_FILE "mrec.pcmu"
#define DEFAULT_TMP_FILE "mrec.raw"
#define DEFAULT_TMP_WAV_FILE "untitled.wav"
#define DEFAULT_TMP_ILBC_FILE "mrec.ilbc"

/*
gboolean doSave(const gchar *tmpfile, const gchar *target, AudioFormat format);
*/

gboolean openFile(const gchar *filename, AudioFormat *format, gchar **tmpfile);

gboolean saveFile(const gchar *filename, const gchar *tmpfile, AudioFormat format, gchar **newfile);

const gchar * getExtension(gint format);

GnomeVFSFileSize getFileLength(const gchar *file);

gchar *file2uri(const gchar *filename);

G_END_DECLS

#endif

