/* vim: set ts=4 sw=4 et: */
/*
 * maemo-recorder.c
 *
 * Copyright (C) 2006 Nokia Corporation
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <libosso.h>
#include <gst/gst.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <libgnomevfs/gnome-vfs.h>
#include <locale.h>

#include "maemo-recorder.h"
#include "maemo-recorder-ui.h"
#include "settings.h"

static gboolean createData(AppData **data);
static gboolean destroyData(AppData *data);

static gboolean 
createData(AppData **data)
{
    *data = (AppData *) g_malloc0((gulong)sizeof(AppData));

    g_assert(*data);

    ((AppData *)*data)->state = APPSTATE_READY;
    ((AppData *)*data)->saved = TRUE;

    return TRUE;
}

static gboolean 
destroyData(AppData *data)
{
    g_free(data->openFileName);
    g_free(data->saveFileName);
    g_free(data);

    return TRUE;
}

static gint
cbDBus(const gchar *interface, const gchar *method,
	      GArray *arguments, gpointer data,
	      osso_rpc_t *retval)
{
    ULOG_INFO("dbus: %s, %s", interface, method);

    if (!strcmp(method, "top_application"))
        gtk_window_present(GTK_WINDOW(data));

    retval->type = DBUS_TYPE_INVALID;
    return OSSO_OK;
}

int
main(int argc, char *argv[])
{
    AppData *appData;
    osso_return_t ret;
    guint minor = 0, major = 0, micro = 0, nano = 0;

    /* Initialise the locale stuff */
    setlocale(LC_ALL, "");
    bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);

    ULOG_OPEN("maemo_recorder " PACKAGE_VERSION);
    ULOG_INFO("maemo-recorder %s", PACKAGE_VERSION);

    createData (&appData);

    appData->osso = osso_initialize(SERVICE_NAME,
				     PACKAGE_VERSION, FALSE, NULL);
    if (appData->osso == NULL)
    {
        ULOG_CRIT("osso_initialize() failed");
        exit(1);
    }

    if (osso_mime_set_cb(appData->osso,
             (osso_mime_cb_f *)  (&maemo_recorder_mime_open),
             (gpointer) appData
             ) != OSSO_OK)
    {
        ULOG_CRIT("osso_mime_set_cb() failed");
    }

    /* initialise gst */
    gst_init(&argc, &argv);
    gst_version (&major, &minor, &micro, &nano);
    gnome_vfs_init();

    ULOG_INFO("This program utilises GStreamer %d.%d.%d.%d", major, minor, micro, nano);
    /* ULOG_DEBUG("GST_SECOND is %llu", GST_SECOND); */

    /* initialise gtk */
    gtk_init(&argc, &argv);

    appData->gconf_client = settings_init(argc, argv);

    maemo_recorder_ui_new(appData);

    ret = osso_rpc_set_default_cb_f(appData->osso, 
                 cbDBus, 
                 appData->mainView);

    if (ret != OSSO_OK)
    {
        ULOG_CRIT("osso_rpc_set_default_cb_f() failed: %d, exiting", ret);
        LOG_CLOSE();
        exit(1);
    }
  
    gtk_main();

    osso_mime_unset_cb(appData->osso);
    osso_deinitialize(appData->osso);
    destroyData(appData);

    ULOG_INFO("maemo-recorder exiting");

    LOG_CLOSE();
    return 0;
}


/* general utilities  */

void 
setAppState(AppData *app, AppState state)
{
    app->state = state;
}

AppState 
getAppState(AppData *app)
{
    return app->state;
}

#if 0
AudioFormatSpec *
audio_format_spec_new(void)
{
    AudioFormatSpec *af = NULL;

    af = (AudioFormatSpec *) g_malloc0(sizeof(AudioFormatSpec));
    g_assert(af);

    return af;
}

void
audio_format_spec_free(AudioFormatSpec *af)
{
    if (NULL == af)
        return;

    if (af->mime_type != NULL)
    {
        g_free(af->mime_type);
        af->mime_type = NULL;
    }
    
    g_free(af);
}

const gchar *
get_mime_type(const AudioFormatSpec *af)
{


}

const gchar *
get_gst_mime_type(AudioFormat af)
{
    /* MUST keep in sync with AudioFormat enum */
    static char * gst_types[] = 
    {
        NULL,
        GST_TYPE_PCM,
        GST_TYPE_PCMA,
        GST_TYPE_PCMU,
        GST_TYPE_ILBC,
        NULL
    };

    return gst_types[af];
}
#endif
