/* vim: set ts=4 sw=4 et: */
/*
 * maemo-recorder-au.h
 * Support for reading and writing AU/SND files
 *
 * Copyright (C) 2006 Nokia Corporation
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef MAEMO_RECORDER_AU_H
#define MAEMO_RECORDER_AU_H

#include <libgnomevfs/gnome-vfs.h>

#include <stdio.h>

G_BEGIN_DECLS

#define AU_MAGIC ((uint32_t) 0x2e736e64) /* ".snd" */
#define AU_SIZE_UNKNOWN (~0)    /* (unsigned) -1 */

enum
{
    AU_ENCODING_MULAW_8 = 1,    /* 8-bit ISDN u-law */
    AU_ENCODING_LINEAR_8 = 2,   /* 8-bit linear PCM */
    AU_ENCODING_LINEAR_16 = 3,  /* 16-bit linear PCM */
    AU_ENCODING_LINEAR_24 = 4,  /* 24-bit linear PCM */ 
    AU_ENCODING_LINEAR_32 = 5,  /* 32-bit linear PCM */ 
    AU_ENCODING_FLOAT = 6,      /* 32-bit IEEE floating point */ 
    AU_ENCODING_DOUBLE = 7,     /* 64-bit IEEE floating point */ 
    AU_ENCODING_ADPCM_G721 = 23,    /* 4-bit CCITT g.721 ADPCM */ 
    AU_ENCODING_ADPCM_G722 = 24,    /* CCITT g.722 ADPCM */ 
    AU_ENCODING_ADPCM_G723_3 = 25,  /* CCITT g.723 3-bit ADPCM */ 
    AU_ENCODING_ADPCM_G723_5 = 26,  /* CCITT g.723 5-bit ADPCM */ 
    AU_ENCODING_ALAW_8 = 27    /* 8-bit ISDN A-law */
};

struct au_header 
{
    uint32_t magic;
    uint32_t data_offset;
    uint32_t data_size;
    uint32_t encoding;
    uint32_t sample_rate;
    uint32_t channels;

} __attribute__((__packed__));


gint au_write(GnomeVFSHandle *handle, guint32 encoding, guint32 rate, guint32 channels, gconstpointer data, size_t len);

gint 
au_write_copy(GnomeVFSHandle *to_handle, guint32 encoding, guint32 rate, guint32 channels, GnomeVFSHandle *from_handle, size_t len);

gint
au_get_info(GnomeVFSHandle *handle, guint32 *format, guint32 *rate, guint32 *channels, guint32 *data_size, guint32 *data_offset);

gint au_copy_data(GnomeVFSHandle *to_handle, GnomeVFSHandle *from_handle, guint32 from_offset);

guint32 au_get_encoding(AudioFormat format);

G_END_DECLS

#endif
