#!/bin/sh
# cd /usr/lib/hildon-desktop
# python2.5 recaller2.py

import gobject
import gtk
import hildondesktop
import hildon
import os
import cairo
import osso
import string
import time 

import pygst
pygst.require("0.10")
import gst

HOME = os.getenv('HOME')
APP_VERSION = "0.2"

class Recaller2HomePlugin(hildondesktop.HomePluginItem):

  def __init__(self):
    hildondesktop.HomePluginItem.__init__(self)
    #self.set_settings(True)
    #self.connect("show-settings", self.show_options)
    
    # Creates the main UI
    self.isStopped = True 
    self.update_info()
    self.transparency = 0.0 

  def update_info(self, widget=None):
    # Deinitialize images
    #try:
    #   self.vbox.destroy()
    #   self.hbox.destroy()
    #   self.e_eventbox.destroy()
    #except Exception:
    #   pass # This is probably a first-run

    self.osso_context = osso.Context("com.tomch.recaller", str(APP_VERSION), False)
    self.osso_rpc = osso.Rpc(self.osso_context)
   
    self.hbox = gtk.HBox()
    self.vbox = gtk.VBox()
    self.e_eventbox = gtk.EventBox()
    self.e_eventbox.set_size_request(48, 64) 
    self.e_eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
    self.e_eventbox.connect("button-release-event", self.on_toggled)
    self.hbox.pack_start(self.e_eventbox, True, True, 10)
    self.hbox.show_all()
    self.add(self.hbox)
    
  def do_expose_event(self, event):
    cr = self.window.cairo_create()
    cr.set_source_rgba(1.0, 1.0, 1.0, self.transparency) # Transparent

    # Draw the background
    cr.set_operator(cairo.OPERATOR_SOURCE)
    cr.paint()   
    # Paint icon for eventbox
    self.draw_e_off()
    # draw rounded rect
    width, height = self.allocation[2], self.allocation[3]
    
    x0 = 0
    y0 = 0
    radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */
    x1 = x0 + width
    y1 = y0 + height
    
    cr.move_to  (x0, y0 + radius)
    cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
    cr.line_to (x1 - radius, y0)
    cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
    cr.line_to (x1 , y1 - radius)
    cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
    cr.line_to (x0 + radius, y1)
    cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)
    cr.close_path ()

    cr.set_source_rgba (0.0, 0.0, 0.0, self.transparency)
    cr.fill_preserve ()
    return False

  def draw_e_off(self):
    cr_e = self.e_eventbox.window.cairo_create()
    cr_e.set_source_rgba(0.0, 0.0, 0.0, self.transparency) # Transparent
    cr_e.set_operator(cairo.OPERATOR_SOURCE)
    cr_e.paint()
    
    cr_e.set_operator(cairo.OPERATOR_OVER)
    image = cairo.ImageSurface.create_from_png("/usr/share/icons/hicolor/48x48/hildon/recaller.png")
    cr_e.set_source_surface(image, 0, 7)
    cr_e.paint()
    self.cr_e = cr_e

  def draw_e_on(self):
    cr_e = self.e_eventbox.window.cairo_create()
    cr_e.set_source_rgba(0.0, 0.0, 0.0, self.transparency) # Transparent
    cr_e.set_operator(cairo.OPERATOR_SOURCE)
    cr_e.paint()
    
    cr_e.set_operator(cairo.OPERATOR_OVER)
    image = cairo.ImageSurface.create_from_png("/opt/tomch.com/recaller/recaller-on.png")
    cr_e.set_source_surface(image, 0, 7)
    cr_e.paint()

  def do_realize(self):
    screen = self.get_screen()
    colormap = screen.get_rgba_colormap()
    self.set_colormap(colormap)
    hildondesktop.HomePluginItem.do_realize(self)
   

  def on_toggled(self, button, data=None):
    if self.isStopped==True:
      #Button got activated, start the recording
      self.isStopped=False
      self.draw_e_on()
      self.startTime =  time.strftime("%Y%m%d_%H%M%S")
      self.fileName = "/home/user/MyDocs/Rec_%s.aac" % self.startTime
      print self.fileName
      self.player = gst.parse_launch ("adder name=theAdder ! nokiaaacenc bitrate=128000 output-format=2 ! filesink location=%s. pulsesrc device=sink.hw0.monitor ! queue ! theAdder. pulsesrc device=source.hw0 ! queue ! theAdder." % self.fileName)
      self.player.set_state(gst.STATE_PLAYING)
      banner = hildon.hildon_banner_show_information(self, "", "recaller: Conversation recording has started.")
      banner.set_timeout(2000)
      print "recaller: " + time.strftime("%H:%M:%S") + " - Conversation started."
    else:
      #Button got deactivated. stop the recording
      self.draw_e_off()
      self.player.set_state(gst.STATE_NULL)
      finalName = "/home/user/MyDocs/Rec_%s-%s.aac" % (self.startTime, time.strftime("%H%M%S"))
      print finalName 
      time.sleep(2)
      os.rename(self.fileName, finalName)
      banner = hildon.hildon_banner_show_information(self, "", "recaller: Conversation recording was stopped.")
      banner.set_timeout(2000)
      self.isStopped=True
      print "recaller: " + time.strftime("%H:%M:%S") + " - Conversation stopped."   

  def on_message(self, bus, message):
    t = message.type
    if t == gst.MESSAGE_EOS:
      self.player.set_state(gst.STATE_NULL)
    elif t == gst.MESSAGE_ERROR:
      self.player.set_state(gst.STATE_NULL)
    #err, debug = message.parse_error()
    #print "recaller on_message: %s" % err, debug
    #banner = hildon.hildon_banner_show_information(self, "", "recaller: " + message.parse_error())
    #banner.set_timeout(2000)  

  def on_sync_message(self, bus, message):
    if message.structure is None:
      return
    message_name = message.structure.get_name()
    if message_name == 'prepare-xwindow-id':
      return
      # Assign the viewport
      #imagesink = message.src
      #imagesink.set_property('force-aspect-ratio', True)
      #imagesink.set_xwindow_id(self.movie_window.window.xid)
         
         
hd_plugin_type = Recaller2HomePlugin

if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()
