#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice, random
import time

class SizeGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties        
        self.gem = Gem(self.reactor)
        self.speed = choice([0.01,0.02,0.03])
        self.targetSize = random()*(3-0.7)+0.7
        self.currentSize = 0.5
        self.step = 0
        self.initial = True
        # Universal Properties
        self.task ="Hit it when the second gem is as large as the first"
    
    def play(self):
        if self.initial:
            self.step = 80
            self.initial = False
            initGem = pygame.transform.rotozoom(self.gem.gem, 0, self.targetSize)
            self.reactor.screen.blit(initGem, 
                                     self.upperLeftCorner(initGem))
        if self.step == 0:
            self.currentSize = self.currentSize + self.speed
            stepGem = pygame.transform.rotozoom(self.gem.gem, 0, self.currentSize)
            self.reactor.clearPlayArea()
            self.reactor.screen.blit(stepGem,
                                     self.upperLeftCorner(stepGem))
        else:
            self.step = self.step - 1
    
    def upperLeftCorner(self, gem):
        x = self.reactor.screen.get_width()/2-gem.get_width()/2
        y = self.reactor.screen.get_height()/2-gem.get_height()/2
        return (x, y)
    
    def evaluate(self, player):
        bigger = self.currentSize > self.targetSize
        if bigger:
            self.winMessage = "Well measured"
            self.loseMessage = "Too slow!"
            if player == 1: return 1
            if player == 2: return 2
        else:
            self.winMessage = "You win!"
            self.loseMessage = "%(#).03f times to small!" % {
                               "#": self.targetSize - self.currentSize}
            if player == 1: return 2
            if player == 2: return 1
            
class Gem(object):
    def __init__(self, reactor):
        self.reactor = reactor
        self.type = choice(range(1,7))
        self.gem, self.gemRect = self.reactor.load_image(
                                 'gem0' + str(self.type) + '.png', -1)
        
    def __eq__(o1, o2):
        if o1.type == o2.type:
            return True
        else:
            return False
            
    def __hash__(self):
        return self.type
        
        
        
        
        
        
        
        
        
        
