#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice
import time

class MinSymbolsGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties        
        self.gems = [Gem(self.reactor) for i in xrange(9)]
        self.step = 0
        self.slots = []
        self.types = []
        self.turn = 0
        w = self.reactor.screen.get_width() - 360 - 150
        h = self.reactor.screen.get_height() - 60 - 150
        for x in range(0, 3):
            for y in range(0, 3):
                self.slots.append([x*(w/2)+180,y*(h/2)+30])
        # Universal Properties
        self.task = "There are at least 5 different gems"
    
    def play(self):
        if self.step == 0:
            self.step = 30
            self.reactor.clearPlayArea()
            if self.turn < 9:
                self.reactor.screen.blit(self.gems[self.turn].gem, self.slots[self.turn])
                self.types.append(self.gems[self.turn].type)
                self.turn = self.turn + 1
            else:
                c = choice(range(8))
                self.gems[c] = Gem(self.reactor)
                self.types[c] = self.gems[c].type
            for i in range(0, self.turn):
                self.reactor.screen.blit(self.gems[i].gem, self.slots[i])
        else:
            self.step = self.step - 1
    
    def countDifferent(self):
        diffs = [0]*8 
        for i in self.types:
            diffs[i] += 1
        diff = 0
        for i in diffs:
            if i > 0: diff += 1
        return diff > 4
    
    def evaluate(self, player):
        different = self.countDifferent()
        if different:
            self.winMessage = "Well counted!"
            self.loseMessage = "Too slow!"
            if player == 1: return 1
            if player == 2: return 2
        else:
            self.winMessage = "You win!"
            self.loseMessage = "False!"
            if player == 1: return 2
            if player == 2: return 1
            
class Gem(object):
    def __init__(self, reactor):
        self.reactor = reactor
        self.type = choice(range(1,7))
        self.gem, self.gemRect = self.reactor.load_image(
                                 'gem0' + str(self.type) + '.png', -1)
    
    def __eq__(o1, o2):
        if o1.type == o2.type:
            return True
        else:
            return False
            
    def __hash__(self):
        return self.type
        
        
        
        
        
        
        
        
        
        
