#!/usr/bin/python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
from random import choice
import time

class CountdownGame(object):
    def __init__(self, reactor):
        self.reactor = reactor
        # Game specific properties        
        self.step = 0
        #~ self.negative = False
        self.numbers = {1: "One",
                        2: "Two",
                        3: "Three",
                        4: "Four",
                        5: "Five",
                        6: "Six",
                        7: "Seven",
                        8: "Eight",
                        9: "Nine",
                        10: "Ten"}
        self.targetTime = False
        self.clear = False
        # Universal Properties
        self.task = "Hit it as soon as the countdown reaches zero"
    
    def play(self):
        if not self.targetTime:
            self.targetTime = time.time()+10
            self.currentCount = 10
            self.reactor.clearPlayArea()
            self.reactor.drawMainText(str(self.currentCount))
        self.diff = self.targetTime - time.time()
        if self.diff < self.currentCount-1:
            self.currentCount = int(self.diff)+1
            if self.diff > 3:
                self.reactor.clearPlayArea()
                self.reactor.drawMainText(str(self.currentCount))
            else:
                if not self.clear:
                    self.reactor.clearPlayArea()
                    self.reactor.drawMainText("...")
                    self.clear = True
                    
    def evaluate(self, player):
        reached = (self.diff < 0)
        if reached:
            self.winMessage = "Good! (+%2.3fs)" % (self.diff*-1)
            self.loseMessage = "%2.3fs too late!" % (self.diff*-1)
            if player == 1: return 1
            if player == 2: return 2
        else:
            self.winMessage = "You win!"
            self.loseMessage = "%2.3fs too early!" % self.diff
            if player == 1: return 2
            if player == 2: return 1
