#ifndef MENUWINDOW_H
#define MENUWINDOW_H

#include <QWidget>
#include <QStackedLayout>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPushButton>
#include <QLabel>
#include <QCoreApplication>
#include "gamewindow.h"
#include "speedmatch.h"
#include <QDebug>

class MenuWindow : public QWidget
{
    Q_OBJECT
public:

    MenuWindow( QWidget* aParent = 0 )
        :QWidget( aParent ),mCurrentWidget (0)
    {
        setupUi();        
    }

public slots:

    void showMenu()
    {
        mStackLayout->setCurrentWidget(mMenuWidget);
    }

    void reactionGame()
    {
        if( mCurrentWidget ) {
            mStackLayout->removeWidget( mCurrentWidget);
            delete mCurrentWidget;
        }

        GameWindow* reactionGame = new GameWindow( this );
        mCurrentWidget = reactionGame;
        mStackLayout->addWidget( mCurrentWidget);
        mStackLayout->setCurrentWidget(mCurrentWidget);
        reactionGame->newGame();

        QObject::connect(reactionGame,SIGNAL(showMenu()),this,SLOT(showMenu()));
    }

    void speedMatchGame()
    {
        if( mCurrentWidget ) {
            mStackLayout->removeWidget( mCurrentWidget);
            delete mCurrentWidget;
        }

        SpeedMatch* speedMatchGame = new SpeedMatch( this );
        mCurrentWidget = speedMatchGame;
        mStackLayout->addWidget( mCurrentWidget);
        mStackLayout->setCurrentWidget(mCurrentWidget);
        speedMatchGame->newGame();

        QObject::connect(speedMatchGame,SIGNAL(showMenu()),this,SLOT(showMenu()));
    }

private:

    void setupUi()
    {
        mMenuWidget = createMenuWidget();

        mStackLayout = new QStackedLayout();       
        mStackLayout->addWidget(mMenuWidget);

        QVBoxLayout* mainLayout = new QVBoxLayout(this);
        mainLayout->addLayout( mStackLayout);

        mStackLayout->setCurrentWidget(mMenuWidget);
    }

    QWidget* createMenuWidget()
    {
        QWidget* menuWidget = new QWidget(this);

        QLabel* iconLabel = new QLabel( menuWidget);
        iconLabel->setPixmap( QPixmap(":reaction.png"));
        iconLabel->setAlignment(Qt::AlignCenter);

        QLabel* descLabel = new QLabel(menuWidget);
        descLabel->setText("Improve brain's performance");
        descLabel->setAlignment(Qt::AlignCenter);
        QPushButton* reactionGameBtn = new QPushButton("Reaction Game",menuWidget);
        QPushButton* speedMatchGameBtn = new QPushButton("Speed Match Game",menuWidget);
        QPushButton* helpBtn = new QPushButton("Help",menuWidget);
        QPushButton* quitButton = new QPushButton("Exit",menuWidget);

        QObject::connect(quitButton,SIGNAL(clicked()),QCoreApplication::instance(),SLOT(quit()));
        QObject::connect(reactionGameBtn,SIGNAL(clicked()),this,SLOT(reactionGame()));
        QObject::connect(speedMatchGameBtn,SIGNAL(clicked()),this,SLOT(speedMatchGame()));

        QVBoxLayout* buttonLayout = new QVBoxLayout();
        buttonLayout->addStretch();
        buttonLayout->addWidget(reactionGameBtn);
        buttonLayout->addWidget(speedMatchGameBtn);
        buttonLayout->addWidget(helpBtn);
        buttonLayout->addWidget(quitButton);
        buttonLayout->addStretch();

        QVBoxLayout* iconLayout = new QVBoxLayout;        
        iconLayout->addStretch();
        iconLayout->addWidget(iconLabel);
        iconLayout->addWidget(descLabel);
        iconLayout->addStretch();

        QVBoxLayout* menuLayout = new QVBoxLayout();
        menuLayout->addStretch();
        menuLayout->addWidget(reactionGameBtn);
        menuLayout->addWidget(speedMatchGameBtn);
        menuLayout->addWidget(helpBtn);
        menuLayout->addWidget(quitButton);
        menuLayout->addStretch();

        QHBoxLayout* mainLayout = new QHBoxLayout( menuWidget );
        mainLayout->addStretch();
        mainLayout->addLayout(iconLayout);
        mainLayout->addStretch();
        mainLayout->addLayout(  menuLayout );
        mainLayout->addStretch();

        return menuWidget;
    }

private:
    QWidget* mCurrentWidget;
    QWidget* mMenuWidget;
    QStackedLayout* mStackLayout;

};

#endif // MENUWINDOW_H
