#ifndef MENUWINDOW_H
#define MENUWINDOW_H

#include <QWidget>
#include <QStackedLayout>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPushButton>
#include <QLabel>
#include <QCoreApplication>
#include "gamewindow.h"

class MenuWindow : public QWidget
{
    Q_OBJECT
public:

    MenuWindow( QWidget* aParent = 0 )
        :QWidget( aParent )
    {
        setupUi();
        QObject::connect(mGameWidget,SIGNAL(showMenu()),this,SLOT(showMenu()));
    }

public slots:

    void showMenu()
    {
        mStackLayout->setCurrentWidget(mMenuWidget);
    }

    void newGame()
    {
        mStackLayout->setCurrentWidget(mGameWidget);
        mGameWidget->newGame();
    }

private:

    void setupUi()
    {
        mGameWidget = new GameWindow(this);
        mMenuWidget = createMenuWidget();

        mStackLayout = new QStackedLayout();
        mStackLayout->addWidget(mGameWidget);
        mStackLayout->addWidget(mMenuWidget);

        QVBoxLayout* mainLayout = new QVBoxLayout(this);
        mainLayout->addLayout( mStackLayout);

        mStackLayout->setCurrentWidget(mMenuWidget);


    }

    QWidget* createMenuWidget()
    {
        QWidget* menuWidget = new QWidget(this);

        QLabel* iconLabel = new QLabel( menuWidget);
        iconLabel->setPixmap( QPixmap(":reaction.png"));
        iconLabel->setAlignment(Qt::AlignCenter);

        QLabel* descLabel = new QLabel(menuWidget);
        descLabel->setText("Measure your brain's reaction time.\n More points reflect better reaction time.");
        descLabel->setAlignment(Qt::AlignCenter);
        QPushButton* newGameBtn = new QPushButton("New Game",menuWidget);
        QPushButton* quitButton = new QPushButton("Exit",menuWidget);

        QObject::connect(quitButton,SIGNAL(clicked()),QCoreApplication::instance(),SLOT(quit()));
        QObject::connect(newGameBtn,SIGNAL(clicked()),this,SLOT(newGame()));

        QHBoxLayout* buttonLayout = new QHBoxLayout();
        buttonLayout->addStretch();
        buttonLayout->addWidget(newGameBtn);
        buttonLayout->addWidget(quitButton);
        buttonLayout->addStretch();

        QVBoxLayout* mainLayout = new QVBoxLayout(menuWidget);
        mainLayout->addStretch();
        mainLayout->addWidget(iconLabel);
        mainLayout->addWidget(descLabel);
        mainLayout->addSpacing( 30) ;
        mainLayout->addLayout(buttonLayout);
        mainLayout->addStretch();

        return menuWidget;
    }

private:
    GameWindow* mGameWidget;
    QWidget* mMenuWidget;
    QStackedLayout* mStackLayout;

};

#endif // MENUWINDOW_H
