#!/usr/bin/python2.5
# rapier: a small bible reader for maemo.
# Copyright 2007 Pierre Amadio 
# pierre.amadio@libertysurf.fr
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 2.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""
This script is supposed to be run only once to generate the Strong number
sqlite database. Rapier does not actually needs this script once the database
has been created.
"""

import Sword
import os
import re
import sqlite3
import sys

database_file="/home/user/MyDocs/strong.db"
data_path="/home/user/sword"

def create_tables(db):
    c = db.cursor()
    print "creating tables"
    snt="create table Words (word text primary key)"
    c.execute(snt)
    snt="create table Words_Per_Verse (word text,verse text)"
    c.execute(snt)
    snt="create index word_per_verse_idx on  Words_Per_Verse (word)"
    c.execute(snt)
    snt="create index word_idx on Words (word)"
    c.execute(snt)



def is_word_in_db(db,word):
    c = db.cursor()
    c.execute("select count(*) from Words where word=?",(word,))
    return  c.fetchone()[0]

def is_word_per_verse_in_db(db,word,key):
    c=db.cursor()
    c.execute("select count(*) from Words_Per_Verse where word=? and verse=?",\
            (word,key,))
    return  c.fetchone()[0]

def getAllBooks():
    """
    Return an array:
    [{'testament': 1, 'bookCount': 1, 'name': 'Genesis', 'abbr': 'Gen'},
    {'testament': 1, 'bookCount': 2, 'name': 'Exodus', 'abbr': 'Exod'},
    """
    vk=Sword.VerseKey()
    out=[]
    for i in range(2):
        vk.Testament(i+1)
        for j in range(vk.bookCount(i+1)):
            vk.Book(j+1)
            tmp={}
            tmp['name']=vk.bookName(i+1,j+1)
            tmp['abbr']=vk.getBookAbbrev()
            tmp['testament']=i+1
            tmp['bookCount']=j+1
            out.append(tmp)
    return out
        
def parse_words(verseTxt):
    reg=re.compile("<(\w+)>")
    out=[]
    for i in reg.findall(verseTxt):
        if i not in out:
            out.append(i)
    return out
    
        
        

if os.path.exists(database_file):
    print "Removing old db:%s",database_file
    os.remove(database_file)
    db=sqlite3.connect(database_file)
    create_tables(db)


#db=sqlite3.connect(database_file)


#print "plop",is_word_in_db(db,"plop")
#print "kikoo",is_word_in_db(db,"kikoo")


markup=Sword.MarkupFilterMgr(Sword.FMT_PLAIN)
markup.thisown=False
mgr=Sword.SWMgr(markup)
mgr.prefixPath = data_path
mgr.configPath = "%s/mods.d" % data_path
mgr.augmentModules(data_path)
mod=mgr.getModule('KJV')

for curbook in getAllBooks():
    print "_________________"
    print curbook
    vk=Sword.VerseKey()
    nbr_chapter=vk.chapterCount(curbook['testament'],curbook['bookCount'])
    for chapter_idx in range(nbr_chapter):
        chapter=chapter_idx+1
        print "chapter %s"%chapter
        nbr_verses=vk.verseCount(curbook['testament'],\
                                 curbook['bookCount'],\
                                 chapter)
        for verse_idx in range(nbr_verses):
            verse=verse_idx+1
            key="%s %d:%d"%(curbook['abbr'],chapter,verse)
            print key
            tmpvk=Sword.VerseKey(key)
            mod.setKey(tmpvk)
            mgr.setGlobalOption("Strong's Numbers","On")
            verseTxt=mod.RenderText()
            #print verseTxt
            words=parse_words(verseTxt)
            #print words
            c = db.cursor()
            for cur_word in words:
                if not is_word_in_db(db,cur_word):
                    #print "adding word %s in db"%cur_word
                    c.execute("insert into Words (word) values (?)"\
                              ,(cur_word,))
                if not is_word_per_verse_in_db(db,cur_word,key):
                    #print "adding association (%s,%s)"%(cur_word,verse)
                    c.execute("insert into Words_Per_Verse (word,verse) values (?,?)"\
                              ,(cur_word,key))
                db.commit()
            print "\n"

db.commit()
