/*
 *  Raamattu - a simple Bible reader
 *  Copyright (C) 2011  Xizhi Zhu <xizhi.zhu@gmail.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import Qt 4.7
import "content"

Rectangle {
    id: wrapper

    property int bookIndex
    property int chapterIndex
    property int chapterNumber
    property string headerText

    width: 480; height: 800
    state: "bookView"

    BookModel { id: bookModel }

    Rectangle {
        width: wrapper.width; height: 50; z: 1; opacity: 0.9
        gradient: Gradient {
            GradientStop { position: 0.0; color: "gray" }
            GradientStop { position: 1.0; color: "black" }
        }

        Text {
            text: headerText
            color: "white"; font { pixelSize: 30; bold: true }
            anchors.centerIn: parent
        }
    }

    BookView {
        id: bookView
        width: wrapper.width; height: wrapper.height - 100; x: 0; y: 50; z: 0
    }

    ChapterView {
        id: chapterView
        width: wrapper.width; height: wrapper.height - 100; x: -(wrapper.width * 1.5); y: 50; z: 0
    }

    BibleTextView {
        id: bibleTextView
        width: wrapper.width; height: wrapper.height - 100; x: -(wrapper.width * 1.5); y: 50; z: 0
    }

    Rectangle {
        width: wrapper.width; height: 50; y: wrapper.height - 50; z: 1; opacity: 0.9
        gradient: Gradient {
            GradientStop { position: 0.0; color: "gray" }
            GradientStop { position: 1.0; color: "black" }
        }

        Button {
            id: button1
            buttonText: qsTr("Back"); buttonTextSize: 20; buttonEnabled: true
            visible: (wrapper.state == "bookView" && wrapper.bookIndex > 0 && wrapper.chapterIndex > 0 && wrapper.chapterNumber > 0)
                     || (wrapper.state == "chapterView" && wrapper.bookIndex > 0)
                     || (wrapper.state == "bibleTextView")
            anchors.left: parent.left; anchors.leftMargin: 5; anchors.verticalCenter: parent.verticalCenter
            width: 70; height: 40
            onClicked: {
                if (wrapper.state == "bookView")
                    wrapper.state = "bibleTextView"
                else if (wrapper.state == "chapterView")
                    wrapper.state = "bookView"
                else if (wrapper.state == "bibleTextView")
                    wrapper.state = "bookView"
            }
        }

        Button {
            id: button2
            buttonText: qsTr("Prev"); buttonTextSize: 20; buttonEnabled: wrapper.chapterIndex > 1
            anchors.left: button1.right; anchors.leftMargin: 10; anchors.verticalCenter: parent.verticalCenter
            visible: wrapper.state == "bibleTextView"
            width: 70; height: 40
            onClicked: {
                if (wrapper.chapterIndex > 1) {
                    --wrapper.chapterIndex
                    bibleTextModel.setBibleText(wrapper.bookIndex, wrapper.chapterIndex)
                }
            }
        }

        Button {
            id: button3
            buttonText: qsTr("Next"); buttonTextSize: 20; buttonEnabled: wrapper.chapterIndex < wrapper.chapterNumber
            anchors.left: button2.right; anchors.leftMargin: 10; anchors.verticalCenter: parent.verticalCenter
            visible: wrapper.state == "bibleTextView"
            width: 70; height: 40
            onClicked: {
                if (wrapper.chapterIndex < wrapper.chapterNumber) {
                    ++wrapper.chapterIndex
                    bibleTextModel.setBibleText(wrapper.bookIndex, wrapper.chapterIndex)
                }
            }
        }

        Button {
            id: button6
            buttonText: qsTr("Exit"); buttonTextSize: 20; buttonEnabled: true
            anchors.right: parent.right; anchors.rightMargin: 5; anchors.verticalCenter: parent.verticalCenter
            width: 70; height: 40
            onClicked: Qt.quit()
        }
    }

    states: [
        State {
            name: "bookView"
            PropertyChanges { target: wrapper; headerText: qsTr("Select a book") }
            PropertyChanges { target: bookView; x: 0 }
            PropertyChanges { target: chapterView; x: -(wrapper.width * 1.5) }
            PropertyChanges { target: bibleTextView; x: -(wrapper.width * 1.5) }
        },
        State {
            name: "chapterView"
            PropertyChanges { target: wrapper; headerText: qsTranslate("BookModel", bookModel.get(wrapper.bookIndex - 1).name) }
            PropertyChanges { target: bookView; x: -(wrapper.width * 1.5) }
            PropertyChanges { target: chapterView; x: 0 }
            PropertyChanges { target: bibleTextView; x: -(wrapper.width * 1.5) }
        },
        State {
            name: "bibleTextView"
            PropertyChanges { target: wrapper; headerText: qsTranslate("BookModel", bookModel.get(wrapper.bookIndex - 1).name) + " " + wrapper.chapterIndex }
            PropertyChanges { target: bookView; x: -(wrapper.width * 1.5) }
            PropertyChanges { target: chapterView; x: -(wrapper.width * 1.5) }
            PropertyChanges { target: bibleTextView; x: 0 }
        }
    ]
    transitions: [
        Transition { NumberAnimation { properties: "x"; duration: 500; easing.type: Easing.InOutQuad } }
    ]
}
