/*
 *  Raamattu - a simple Bible reader
 *  Copyright (C) 2011  Xizhi Zhu <xizhi.zhu@gmail.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import Qt 4.7

Flickable {
    contentWidth: parent.width; contentHeight: 60 * Math.ceil(wrapper.chapterNumber / 4)

    Grid {
        columns: 4; spacing: 5
        Repeater {
            model: wrapper.chapterNumber
            Button {
                width: 115; height: 55
                buttonText: index + 1; buttonEnabled: true; buttonTextSize: 30
                onClicked: {
                    wrapper.chapterIndex = index + 1
                    bibleTextModel.setBibleText(wrapper.bookIndex, wrapper.chapterIndex)
                    wrapper.state = "bibleTextView"
                }
            }
        }
    }
}
